-- Sticker collection and groups

CREATE TABLE sticker_collection (
  _id INTEGER PRIMARY KEY AUTOINCREMENT,
  group_id       integer NOT NULL,
  name          text    NOT NULL
);


CREATE TABLE sticker_collection_group (
  _id integer PRIMARY KEY,
  g_name text NOT NULL,
  g_icon text NOT NULL,
  _order integer UNIQUE,
  is_loaded BOOLEAN DEFAULT 0,
  is_paid BOOLEAN DEFAULT 0,
  inapp_product_id text,
  price text,
  apk_id_suffix text,
  event text,
  is_new BOOLEAN DEFAULT 0,
  title text
);


CREATE TABLE inapp (
  _id INTEGER PRIMARY KEY AUTOINCREMENT,
  inapp_product_id text UNIQUE,
  price text,
  is_paid_up BOOLEAN DEFAULT 0,
  inapp_purchase_data text,
  inapp_signature text
);


INSERT INTO `inapp` (inapp_product_id) VALUES ('sticker_pack_flourish_love');
INSERT INTO `inapp` (inapp_product_id) VALUES ('sticker_pack_funky_food');
INSERT INTO `inapp` (inapp_product_id) VALUES ('sticker_pack_funny_monsters');
INSERT INTO `inapp` (inapp_product_id) VALUES ('sticker_pack_grunge_love');
INSERT INTO `inapp` (inapp_product_id) VALUES ('sticker_pack_jolly_animals');
INSERT INTO `inapp` (inapp_product_id) VALUES ('sticker_pack_love_stamps');
INSERT INTO `inapp` (inapp_product_id) VALUES ('sticker_pack_sporty_props');
INSERT INTO `inapp` (inapp_product_id) VALUES ('sticker_pack_zodiac_signs');
INSERT INTO `inapp` (inapp_product_id) VALUES ('sticker_pack_funky_music');
INSERT INTO `inapp` (inapp_product_id) VALUES ('sticker_pack_hipster_music');
INSERT INTO `inapp` (inapp_product_id) VALUES ('sticker_pack_hipster_party');
INSERT INTO `inapp` (inapp_product_id) VALUES ('sticker_pack_wicked_halloween');
INSERT INTO `inapp` (inapp_product_id) VALUES ('sticker_pack_weather');
INSERT INTO `inapp` (inapp_product_id) VALUES ('sticker_pack_christmas_overlays');
INSERT INTO `inapp` (inapp_product_id) VALUES ('sticker_pack_xmas_photo_booth');
INSERT INTO `inapp` (inapp_product_id) VALUES ('sticker_pack_winter_fun');
INSERT INTO `inapp` (inapp_product_id) VALUES ('sticker_pack_holiday_captions');
INSERT INTO `inapp` (inapp_product_id) VALUES ('sticker_pack_scrapbooking');
INSERT INTO `inapp` (inapp_product_id) VALUES ('sticker_pack_sentimental_heart');
INSERT INTO `inapp` (inapp_product_id) VALUES ('sticker_pack_fine_birds');


INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'arrow_red');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'butterfly_paper');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'clip');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'colorful_paper_star');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'corner_yellow');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'ellipse_blue');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'ellipse_gray');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'ellipse_orange');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'ellipse_red');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'orange_paper_star');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'pink_paper_star');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'red_paper_star');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'washi_tape_blue_strips');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'washi_tape_colorful_strips');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'washi_tape_red_strips');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'washi_tape_retro_gray_dots');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'arrow_colorful');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'buttons');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'corner_dots_pattern');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'hearts');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'joy');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'paper_clip_love');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'ribbon_stripes');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'ribbon_wave_green');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'ribbon_wave_orange');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'shape');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'smile');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'black_bow-knot');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'black_hat_small');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'xmas_photo_booth_hat');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'sentimental_heart_bear');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'sentimental_heart_bunny');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'sentimental_heart_hearts_3');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'sentimental_heart_hearts_4');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'sentimental_heart_three_hearts');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'sentimental_heart_white_heart');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'sentimental_heart_white_hearts');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'yummy_valentine_donut_chocolate');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'yummy_valentine_donut_pink');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'yummy_valentine_flowers');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'yummy_valentine_hearts');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'love_stamps_love2');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'love_captions_always_and_forever_3');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'love_captions_be_my_date_1');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'love_captions_come_what_may');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'love_captions_fall_for_you_1');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'love_captions_fall_for_you_2');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'love_captions_heart_1');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'love_captions_heart_2');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'love_captions_mad_about_you_2');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'love_captions_number_one_1');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'love_captions_number_one_2');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'love_captions_to_the_moon_and_back_1');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'love_captions_you_and_me_1');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'love_captions_you_and_me_2');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'love_captions_you_and_me_4');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'love_captions_you_and_me_5');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'love_captions_you_are_my_wings');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'love_captions_you_rock_my_world_1');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'love_captions_you_rock_my_world_2');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'fine_birds_crows');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'fine_birds_feather');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'fine_birds_nestling');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'fine_birds_on_branch');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'fine_birds_swallows');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'bird_stamp');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'postage');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'stamp');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'weather_rainbow');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'orange_cat');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'jolly_animals_white_dog');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'funky_food_apple');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'funky_food_pear');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_1');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_10');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_11');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_12');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_14');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_15');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_16');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_17');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_18');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_19');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_2');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_20');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_22');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_23');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_24');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_25');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_26');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_28');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_29');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_3');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_30');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_31');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_32');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_4');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_5');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_6');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_7');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_8');
INSERT INTO `sticker_collection` (group_id, name) VALUES (10000, 'geometry_9');

INSERT INTO `sticker_collection_group` VALUES (10000, 'popular',           'orange_paper_star',                        0,    1, 0, NULL, NULL, NULL, 'valentine|easter|mothers_day|summer|halloween|sport|fathers_day|christmas|winter|st_patrick', 0, '{"de":"Beliebte","fr":"Populaires","en":"Popular","ru":"Популярные","it":"Popolari","es":"Decoración","pt-rBR":"Popular","ja":"人気","ko":"인기","zh":"流行的","th":"ติดปากน"}');
