
var defaultLocale = "en-us";

window.onload = startPage;

function startPage() {

  var ua = window.navigator.userAgent;
  var androidversion = parseFloat(ua.slice(ua.indexOf("Android")+8));

  var isEdge = /Edge/.test(navigator.userAgent);
  var isAndroid = ! isNaN(androidversion);

  //
    // Localize page elements

    var locale = window.i18n[$.url("?locale").toLowerCase()] || window.i18n[defaultLocale];

    $("[i18n]")
        .each( function() {
          var id = $(this).attr('i18n');
          if (id === "") {
            id = $(this).attr('id');
          }
          var localizedText = locale[id];
          var fontScaler = locale[id + ".size"];
          var regularFontSize = $(this).css('font-size');

            if (!localizedText) {
                console.error(
                  'Could not find localized text with ID', id);
            } else {
                $(this).html(localizedText);
                if (!fontScaler) { fontScaler = 1.0; }
                $(this).attr("original-font-size", regularFontSize);
                $(this).attr("custom-font-scale", fontScaler);
            }
        });
    

    //
    // Layout calculation
    
    var $win = $(window),
        $view = $("#view"),
        $contentArea = $(".content"),
        $pencil = $("#pencil"),
        $autodeskIcon = $("#autodesk-icon"),
        $startDrawingButton = $("#start_drawing_button"),
        $startDrawingTop = $("#start_drawing_top"),
        $startDrawingShadow = $("#start_drawing_shadow"),
        $welcomeText = $("#welcome"),
        $createAccountButton = $("#create_account"),
        $signInButton = $("#sign_in"),
        $whyAccount = $("#why_use_an_account")
        ;
    
    function layout() {

      //
      // Window sizing

      var win = {
        w: $win.width(),
        h: $win.height(),
      };

      win.c = { x: win.w / 2, y: win.h / 2 };


      //
      // Delay layout calculations if the window isn't ready yet.
      // Added for race conditions on UWP that cause the window to often think
      // it's finished rendering while reporting a size of 1 x 1 pixels. :(

      if (win.w <= 1 || win.h <= 1) {
        return setTimeout(layout, 1);
      }

      //
      // Content sizing

      var content = {
        w: 418,
        h: 418,
      };

      content.c = { x: content.w / 2, y: content.h / 2 };


      win.scale = win.h / content.h;
      win.scaled = { w: win.w / win.scale, h: win.h / win.scale };


      content.pencil = {
        x: 173 - 187.5,
        y: 70 - 125,
        w: 187.5,
        h: 125,
      };

      content.welcome = {
        x: content.c.x - 220/2,
        y: 85,
        w: 220,
        h: 26,
        f: $welcomeText.attr("custom-font-scale") * 26.0,
      };

      content.start_drawing = {
          x: content.c.x - 162/2,
          y: 160,
          w: 162,
          h: 34,
      };

      content.logo = {
        x: content.c.x - 26/2,
        y: 263,
        w: 26,
        h: 26,
      };

      content.create_account = {
        x: content.c.x - 132/2,
        y: 306,
        w: 132,
        h: 25,
        b: 1.2,
      };

      content.sign_in = {
        x: content.c.x - 132/2,
        y: 348,
        w: 132,
        h: 25,
        b: 1.2,
      };

      content.why_account = {
        x: content.c.x - Math.min(220, win.scaled.w) /2,
        y: 390,
        w: Math.min(220, win.scaled.w),
        h: 25,
      };

      content.logo_box = {
        x: content.c.x - 68 / 2,
        y: content.c.y - 68 / 2,
        w: 68,
        h: 68,
      };

      content.logo_mask = {
        x: content.c.x -  460 / 2,
        y: content.c.y -  460 / 2,
        w: content.w,
        h: content.h,
      };


      content.view = {
        w: 300,
        h: 418,
      };
      content.view.c = { x: content.view.w / 2, y: content.view.h / 2 };


      $view.css({
        left: win.c.x - (win.scale * content.view.w / 2),
        top: 0,
        width: win.scale * content.view.w,
        height: win.h,
      });

      //
      // page area

      $contentArea.css({
        left: win.scale * (content.view.c.x - (content.w / 2)),
        top: 0,
        width: win.scale * content.w,
        height: win.scale * content.h,
      });

      //
      // Pencil

      $pencil.css({
        left: win.scale * content.pencil.x,
        top: win.scale * content.pencil.y,
        width: win.scale * content.pencil.w,
        height: win.scale * content.pencil.h,
      });

      //
      // Welcome text

      $welcomeText.css({
        left: win.scale * content.welcome.x,
        top: win.scale * content.welcome.y,
        width: win.scale * content.welcome.w,
        height: win.scale * content.welcome.h,
        'font-size': win.scale * content.welcome.f,
      });

      $welcomeText.find("strong").css({
        'font-size': win.scale * 26,
      });

      //
      // Start Drawing button

      $startDrawingButton.css({
          left: win.scale * content.start_drawing.x,
          top: win.scale * content.start_drawing.y,
          width: win.scale * content.start_drawing.w,
          height: win.scale * (content.start_drawing.h + 5),
        });

      $startDrawingTop.add($startDrawingShadow).each( function () {
          var regularFontSize = parseFloat($(this).attr("original-font-size"));
          var fontScaler = parseFloat($(this).attr("custom-font-scale"));
          $(this).css({
            left: 0,
            top: 0,
            width: win.scale * content.start_drawing.w,
            height: win.scale * content.start_drawing.h,
            'border-radius': win.scale * 4,
            'padding-top':
              win.scale *
              (content.start_drawing.h -
              (fontScaler * regularFontSize) ) / 2,
          });
        });

      $startDrawingShadow.css({
        top: win.scale * 5,
        'box-shadow': "0px 1px 23px 0px rgba(0,0,0,0.24)",

      });

      //
      // Autodesk logo

      $autodeskIcon.css({
        left: win.scale * content.logo.x,
        top: win.scale * content.logo.y,
        width: win.scale * content.logo.w,
        height: win.scale * content.logo.h,
      });

      //
      // Start Drawing button

      $createAccountButton.css({
        left: win.scale * content.create_account.x,
        top: win.scale * content.create_account.y,
        width: win.scale * content.create_account.w,
        height: win.scale * content.create_account.h,
        'border-radius': win.scale * 4,
      });

      $createAccountButton.each( function () {
        var regularFontSize = parseFloat($(this).attr("original-font-size"));
        var fontScaler = parseFloat($(this).attr("custom-font-scale"));
        $(this).css({
          'padding-top':
            win.scale *
            (content.create_account.h -
              (fontScaler * regularFontSize)) / 2,
        });
      });

      $signInButton.css({
        left: win.scale * content.sign_in.x,
        top: win.scale * content.sign_in.y,
        width: win.scale * content.sign_in.w,
        height: win.scale * content.sign_in.h,
        'border-radius': win.scale * 4,
      });

      $signInButton.each( function () {
        var regularFontSize = parseFloat($(this).attr("original-font-size"));
        var fontScaler = parseFloat($(this).attr("custom-font-scale"));
        $(this).css({
          'padding-top':
            win.scale *
            (content.sign_in.h -
              (fontScaler * regularFontSize)) / 2,
        });
      });

      $whyAccount.css({
        left: win.scale * content.why_account.x,
        top: win.scale * content.why_account.y,
        width: win.scale * content.why_account.w,
        height: win.scale * content.why_account.h,
      });


      $("[i18n]").each(
        function () {
          var regularFontSize = parseFloat($(this).attr("original-font-size"));
          var fontScaler = parseFloat($(this).attr("custom-font-scale"));

          $(this).css(
            "font-size",
            win.scale * regularFontSize * fontScaler);
        }
      );


      //
      // Edge clipping polyfill

       if (isEdge || isAndroid) {

      } else {
        $("body").addClass("clip-support");
      }

      //
      // Reveal all

      setTimeout( function () {

        $("body").css({
          opacity: 1
        });

        setTimeout( function () {

          $("body").addClass("show");

        }, 25 );

      }, 25 );

    }

    //
    // Update all "sign in" links with the URL

    $(".sign_in_link")
      .attr("href", decodeURIComponent($.url("?login_url")))
      .on("click tap touchstart", navigate);

    //
    // Update all "create account" links with the URL

    $(".create_account_link")
      .attr("href", decodeURIComponent($.url("?create_account_url")))
      .on("click tap touchstart", navigate);

    //
    // Update all "start drawing" links with the URL

    $(".start_drawing_link")
        .on("click tap touchstart", function(event) {
        $("#start_drawing_top").addClass("press");
      })
        .on("click tap touchstart", navigate);

  //
  // Initiate the layout calculations

  setTimeout( function () { layout(); }, 25 );
  $win.resize(layout);

};

//
// navigation delay function (to account for animation)

function navigate(event) {
    event.preventDefault();
    var dest = $(this).attr('href');
    setTimeout( function () {
        window.location.href = dest;
    }, 750 );
    setTimeout( function () {
      $("body").addClass("navigated");
    }, 100 );
    $("a").off('click');
}
