# Welcome Splashscreen 

The welcome page accepts three URL parameters: login_url, create_account_url, and locale. For example:

```./welcome.html?login_url=https%3A%2F%2Fdeveloper.api.autodesk.com%2Fauthentication%2Fv1%2Fauthorize%3Fresponse_type%3Dcode%26client_id%3DAuGgGKs0On2bxdHRNElDtc19qCSIABlP%26redirect_uri%3Dhttps%3A%2F%2Fapi.sketchbook.com%2Fforge-oauth-callback%26scope%3Ddata%3Aread&create_account_url=https%3A%2F%2Fdeveloper.api.autodesk.com%2Fauthentication%2Fv1%2Fauthorize%3Fresponse_type%3Dcode%26client_id%3DAuGgGKs0On2bxdHRNElDtc19qCSIABlP%26redirect_uri%3Dhttps%3A%2F%2Fapi.sketchbook.com%2Fforge-oauth-callback%26scope%3Ddata%3Aread%26authoptions%3D%257B%2522isregext%2522%253A%2522true%2522%257D%250D%250A&locale=en-us```

All parameter values much be correctly URL-encoded.

#### Parameter value notes:

`login_url`
A full URL (including scheme and host), that will be used to link the user to the forge login page. If missing or malformed, login links in the page will not function correctly.

`create_account_url`
A full URL (including scheme and host), that will be used to link the user directly to the forge account creation page. If missing or malformed, create account links in the page will not function correctly.

`locale`
A  language tag of the form "<_language_>-<_country_>" such as `en-CA` for english as spoken in Canada. These codes must be a case-insenstive exact match for one of the directories under "lang/", otherwise `en-US` will be assumed. Note that language tag matching does not follow [RFC4647](https://tools.ietf.org/html/rfc4647), so loose matching and fallback language hierarchies will not work (e.g. `zh` or `zh-XX` will not default to a supported chinese locale, instead the global english default will be used).


