// Minify with https://jscompress.com/

// stub
var D = {
    func : function () {},
    print : function (text) {},
    error : function (text) {}

};

var FindHelper = (function createFindHelper() {
    D.func();

    function isVisible(element) {
        var res = true;
        var parent = element;
        while (parent && parent.tagName.toLowerCase() != "body" && res) {
            var style = window.getComputedStyle(parent);
            res = style.display != "none" && style.visibility != "hidden" && style.visibility != "collapsed";
            parent = parent.parentNode;
        }
        return res;
    }

    function isOperable(element) {
        if (!isInput(element)) {
            return false;
        }
        return !element.disabled && isVisible(element);
    }

    function isInput(element) {
        return element instanceof HTMLInputElement && (element.type == "text" || element.type == "email" || element.type == "password" || element.type == "number" || element.type == "tel");
    }

    function isSelect(element) {
        return element instanceof HTMLSelectElement;
    }

    return {
        isVisible : function (element) {
            return isVisible(element);
        },

        isOperable : function (element) {
            return isOperable(element);
        },

        isInput : function (element) {
            return isInput(element);
        },

        isSelect : function (element) {
            return isSelect(element);
        }
    };
})();

var InputTester = (function createInputTester() {
    D.func();

    function testAttribute(attribute, pattern) {
        if (pattern && attribute && attribute.length != 0) {
            var regExp = new RegExp(pattern, 'i');
            if (regExp.test(attribute)) {
                return true;
            }
        }
        return false;
    }

    function testInput(input, patterns) {
        if (testAttribute(input.autocomplete, patterns.autocomplete)) {
            return true;
        }
        if (testAttribute(input.id, patterns.anti) || testAttribute(input.name, patterns.anti)) {
            return false;
        }
        if (testAttribute(input.id, patterns.id) || testAttribute(input.name, patterns.id)) {
            return true;
        }
        if (testAttribute(input.type, patterns.type)) {
            return true;
        }
        if (testAttribute(input.value, patterns.value)) {
            return true;
        }
        var labels = input.labels;
        for (var i = 0; labels && i < labels.length; i++) {
            var label = labels[i];
            if (testAttribute(label.textContent, patterns.label)) {
                return true;
            }
        }
        if (testAttribute(input.placeholder, patterns.label || patterns.value)) {
            return true;
        }
        return false;
    }

    return {
        testInput : function (input, patterns) {
            return testInput(input, patterns);
        }
    };
})();

var AccountFinder = (function createAccountFinder() {
    D.func();

    function isLoginInput(input, match) {
        if (input.type == "password") {
            return false;
        }
        if (match == "autocomplete") {
            return InputTester.testInput(input, {
                autocomplete: "^(username|email)$"
            });
        } else if (match == "heuristic") {
            return InputTester.testInput(input, {
                anti: "password",
                id: "user.?name|user.?id|e.?mail|login|customer.?id|customer.?number",
                type: "^(email)$",
                label: "user|e.?mail|login|customer|einloggen|benutzer|usuario|utente|usuário|utilisateur|identifiant|логин|пользователь|gebruiker"
            });
        } else if (match == "desperate") {
            return InputTester.testInput(input, {
                anti: "password",
                type: "^(text|tel)$"
            });
        }
        return false;
    }

    function isPasswordInput(input, match) {
        if (match == "autocomplete") {
            return InputTester.testInput(input, {
                autocomplete: "^(current-password)$"
            });
        } else if (match == "heuristic") {
            if (isNewPasswordInput(input, "autocomplete") || isPasscodeInput(input, "autocomplete") ||
                isNewPasswordInput(input, "heuristic")    || isPasscodeInput(input, "heuristic")) {
                return false;
            }
            return InputTester.testInput(input, {
                id: "password",
                type: "^(password)$",
                label: "password|passwort|contraseña|senha|mot\s*de\s*passe|пароль|wachtwoord"
            });
        }
        return false;
    }

    function isNewPasswordInput(input, match) {
        if (match == "autocomplete") {
            return InputTester.testInput(input, {
                autocomplete: "^(new-password)$"
            });
        } else if (match == "heuristic") {
            return InputTester.testInput(input, {
                id: "new.?password",
                label: "new\s*password|neues\s*passwort|nueva\s*contraseña|nuova\s*password|nova\s*senha|nouveau\s*mot\s*de\s*passe|новый\s*пароль|nieuw\s*wachtwoord"
            });
        }
        return false;
    }

    function isPasscodeInput(input, match) {
        if (match == "autocomplete") {
            return InputTester.testInput(input, {
                autocomplete: "^(one-time-code)$"
            });
        } else if (match == "heuristic") {
            return InputTester.testInput(input, {
                id: "one.?time.*code|otp.?code"
            });
        }
        return false;
    }

    function matchFirstInput(parent, isMatch, match, operableOnly) {
        var inputs = parent.getElementsByTagName("input");
        for (var i = 0; i < inputs.length; i++) {
            var input = inputs[i];
            if (FindHelper.isInput(input) && isMatch(input, match)) {
                if (!operableOnly || FindHelper.isOperable(input)) {
                    return input;
                }
            }
        }
        return null;
    }

    function matchPrevInput(parent, currentInput, isMatch, match, operableOnly) {
        var inputs = parent.getElementsByTagName("input");
        var prevInput = null;
        for (var i = 0; i < inputs.length; i++) {
            var input = inputs[i];
            if (FindHelper.isInput(input)) {
                if (currentInput === input) {
                    return prevInput;
                }
                if (isMatch(input, match)) {
                    if (!operableOnly || FindHelper.isOperable(input)) {
                        prevInput = input;
                    }
                }
            }
        }
        return null;
    }

    function findSubmitForms(operableOnly) {
        D.func(operableOnly);
        var submitForms = [];
        var forms = document.forms;
        for (var i = 0; i < forms.length; i++) {
            var form = forms[i];
            var inputs = findFormInputs(form, isSubmitForm, operableOnly);
            if (inputs) {
                submitForms.push(form);
            }
        }
        return submitForms;
    }

    function isSubmitForm(inputs) {
        return inputs.loginInput && (inputs.passwordInput || inputs.newPasswordInput);
    }

    function isAutofillForm(inputs) {
        if (inputs.newPasswordInput && !inputs.passwordInput) {
            return false;
        }
        return inputs.loginInput || inputs.passwordInput || inputs.passcodeInput;
    }

    function isPasswordForm(inputs) {
        return inputs.passwordInput;
    }

    function isNewPasswordForm(inputs) {
        return inputs.newPasswordInput;
    }

    function isAnyForm(inputs) {
        return true;
    }

    function findFormInputs(form, isMatch, operableOnly) {
        D.func(operableOnly);
        var inputs = {};
        // by autocomplete
        inputs.passwordInput = matchFirstInput(form, isPasswordInput, "autocomplete", operableOnly);
        inputs.loginInput = matchFirstInput(form, isLoginInput, "autocomplete", operableOnly);
        inputs.newPasswordInput = matchFirstInput(form, isNewPasswordInput, "autocomplete", operableOnly);
        inputs.passcodeInput = matchFirstInput(form, isPasscodeInput, "autocomplete", operableOnly);
        // by heuristic
        inputs.passwordInput = inputs.passwordInput || matchFirstInput(form, isPasswordInput, "heuristic", operableOnly);
        if (inputs.passwordInput) {
            inputs.loginInput = inputs.loginInput || matchPrevInput(form, inputs.passwordInput, isLoginInput, "heuristic", operableOnly);
        }
        inputs.loginInput = inputs.loginInput || matchFirstInput(form, isLoginInput, "heuristic", operableOnly);
        // desperate
        if (inputs.passwordInput) {
            inputs.loginInput = inputs.loginInput || matchPrevInput(form, inputs.passwordInput, isLoginInput, "desperate", operableOnly);
        }
        inputs.newPasswordInput = inputs.newPasswordInput || matchFirstInput(form, isNewPasswordInput, "heuristic", operableOnly);
        inputs.passcodeInput = inputs.passcodeInput || matchFirstInput(form, isPasscodeInput, "heuristic", operableOnly);
        // form matches ?
        if (isMatch(inputs)) {
            return inputs;
        }
        return null;
    }

    function findInputs() {
        D.func();
        var inputs = null;
        // search focused form
        if (document.activeElement && document.activeElement.form) {
            inputs = findFormInputs(document.activeElement.form, isPasswordForm, true);
            if (inputs) {
                return inputs;
            }
        }
        // search all forms
        var forms = document.forms;
        if (forms.length > 0) {
            // first with password
            for (var i = 0; i < forms.length; i++) {
                var form = forms[i];
                inputs = findFormInputs(form, isPasswordForm, true);
                if (inputs) {
                    return inputs;
                }
            }
            // then with any of login/password/passcode
            for (var i = 0; i < forms.length; i++) {
                var form = forms[i];
                inputs = findFormInputs(form, isAutofillForm, true);
                if (inputs) {
                    return inputs;
                }
            }
            // finally with misuse of new password
            for (var i = 0; i < forms.length; i++) {
                var form = forms[i];
                inputs = findFormInputs(form, isNewPasswordForm, true);
                if (inputs) {
                    // pseudo-fix
                    inputs.passwordInput = inputs.newPasswordInput;
                    return inputs;
                }
            }
        }
        // search document
        inputs = findFormInputs(document, isAutofillForm, true);
        return inputs;
    }

    return {
        findSubmitForms: function (operableOnly) {
            return findSubmitForms(operableOnly);
        },

        findFormInputs: function (form) {
            return findFormInputs(form, isAnyForm, true);
        },

        findInputs: function () {
            return findInputs();
        },

        getInputValue: function (input) {
            return FindHelper.isInput(input) ? input.value : null;
        }
    };

})();

var InputFiller = (function createInputFiller() {
    D.func();

    function createKeyEvent(target, type) {
        var event = document.createEvent('KeyboardEvent');
        var initMethod = typeof event.initKeyboardEvent !== 'undefined' ? "initKeyboardEvent" : "initKeyEvent";
        event[initMethod](
                    type, // event type : keydown, keyup, keypress
                    true, // bubbles
                    false, // cancelable
                    null, // viewArg: should be window
                    false, // ctrlKeyArg
                    false, // altKeyArg
                    false, // shiftKeyArg
                    false, // metaKeyArg
                    0, // keyCodeArg : unsigned long the virtual key code, else 0
                    0 // charCodeArgs : unsigned long the Unicode character associated with the depressed key, else 0
        );
        return event;
    }

    function createEvent(type) {
        var event = document.createEvent("HTMLEvents");
        event.initEvent(type, true, true);
        return event;
    }

    function fakeKeyEvent(input) {
        D.func();
        input.dispatchEvent(createKeyEvent(input, "keydown"));
        input.dispatchEvent(createKeyEvent(input, "keypress"));
        input.dispatchEvent(createKeyEvent(input, "keyup"));
    }

    function fillText(input, value) {
        D.func();
        if (FindHelper.isInput(input)) {
            // prepare
            input.click();
            input.focus();
            fakeKeyEvent(input);
            // set
            input.value = value;
            // flush
            fakeKeyEvent(input);
            input.dispatchEvent(createEvent("input"));
            input.dispatchEvent(createEvent("change"));
            // just in case
            if (input.value != value) {
                input.value = value;
            }
            return true;
        }
        return false;
    }

    return {
        fillText: function(input, value) {
            return fillText(input, value);
        }
    };
})();

var res = "false";
var inputs = AccountFinder.findInputs();

if (aCommand == "paste_both") {
    // fill login/password
    if (inputs.loginInput || inputs.passwordInput) {
        InputFiller.fillText(inputs.loginInput, aLogin);
        InputFiller.fillText(inputs.passwordInput, aPassword);
        res = "true";
    }
} else if (aCommand == "silent_paste") {
    // only if password found
    if (inputs.passwordInput) {
        InputFiller.fillText(inputs.loginInput, aLogin);
        InputFiller.fillText(inputs.passwordInput, aPassword);
        res = "true";
    }
} else if (aCommand == "paste_login") {
    if (FindHelper.isInput(document.activeElement)) {
        InputFiller.fillText(document.activeElement, aLogin);
        res = "true";
    }
} else if (aCommand == "paste_password") {
    if (FindHelper.isInput(document.activeElement)) {
        InputFiller.fillText(document.activeElement, aPassword);
        res = "true";
    }
} else if (aCommand == "paste_one_time_password") {
    if (FindHelper.isInput(document.activeElement)) {
        InputFiller.fillText(document.activeElement, aPasscode);
        res = "true";
    }
}
