;(function() {
  /* ===== Globals ===== */

  window.VERSION_THANK_EN = "Thank you for choosing Polarr."
  window.VERSION_THANK_CN = "感谢使用泼辣修图。"

  if (CONFIG.os === "windows") {
    window.STORE_TYPE = "windows"
  } else if (CONFIG.os === "osx") {
    window.STORE_TYPE = "osx"
  } else if (CONFIG.os === "web") {
    window.STORE_TYPE = "web"
  } else if (CONFIG.os === "android") {
    window.STORE_TYPE = "play"
  } else if (CONFIG.os === "chrome") {
    window.STORE_TYPE = "chrome"
  } else {
    window.STORE_TYPE = "ios"
  }

  window.MOBILE = CONFIG.platform === "mobile"

  window.FILTER_PACK_KEYS = [
    "co.polarr.ppe.free.filters.pack1",
    "co.polarr.ppe.free.filters.pack2",
    "co.polarr.ppe.purchase.filters.pack1",
    "co.polarr.ppe.purchase.filters.pack2",
    "co.polarr.ppe.purchase.filters.pack3",
    "co.polarr.ppe.purchase.filters.pack4",
    "co.polarr.ppe.purchase.filters.pack5",
    "co.polarr.ppe.purchase.filters.pack6",
    "co.polarr.ppe.purchase.filters.pack7",
    "co.polarr.ppe.purchase.filters.pack8",
    "co.polarr.ppe.purchase.filters.pack9",
    "co.polarr.ppe.purchase.filters.pack10",
    "co.polarr.ppe.purchase.filters.pack11",
    "co.polarr.ppe.purchase.filters.pack12"
  ]

  window.PURCHASE_KEYS_MAP = {
    pro_features: CONFIG.os === "android" ? "photo.editor.polarr.purchase.pro" : "co.polarr.ppe.purchase.pro",
    everything: "co.polarr.ppe.purchase.pro_all_filters",
    all_filters: "co.polarr.ppe.purchase.filters.all",
    local_adjustments: "co.polarr.ppe.purchase.local_adjustments",
    text_tool: "co.polarr.ppe.purchase.text_tool",
    denoise: "co.polarr.ppe.purchase.denoise",
    backup_filters: "co.polarr.ppe.purchase.custom_filter_sync",

    subscription_monthly: "monthly",
    subscription_yearly: "yearly",

    legacy_subscription_monthly: "monthly",
    legacy_subscription_yearly: "yearly",
    legacy_android_premium_discount: "co.polarr.ppe.subscribe.premium",
    legacy_android_premium: "co.polarr.ppe.subscribe.premium.no_discount",
    legacy_android_premium_yearly: "co.polarr.ppe.subscribe.premium.yearly",

    polarr_lite: "co.polarr.ppe.premium.lite",
    polarr_lite_discount: "co.polarr.ppe.lite.discount",
    polarr_lite_yearly: "co.polarr.ppe.premium.lite.yearly",
    polarr_lite_yearly_discount: "co.polarr.ppe.lite.yearly.discount",
    polarr_studio: "co.polarr.ppe.premium.studio",
    polarr_studio_discount: "co.polarr.ppe.studio.discount",
    polarr_studio_yearly: "co.polarr.ppe.premium.studio.yearly",
    polarr_studio_yearly_discount: "co.polarr.ppe.studio.yearly.discount",
    polarr_studio_test: "co.polarr.ppe.premium.studio.test",
    polarr_studio_yearly_test: "co.polarr.ppe.premium.studio.yearly.test",
    polarr_studio_yearly_discount_test: "co.polarr.ppe.studio.yearly.discount.test"
  }

  switch (CONFIG.os) {
    case "ios":
      PURCHASE_KEYS_MAP.subscription_monthly = "co.polarr.ppe.subscribe.premium.all_platforms.monthly.v5.0.0"
      PURCHASE_KEYS_MAP.subscription_yearly = "co.polarr.ppe.subscribe.premium.all_platforms.yearly.v5.0.0"
      break
    case "osx":
      PURCHASE_KEYS_MAP.subscription_monthly = "co.polarr.ppe.desktop.subscribe.premium.all_platforms.monthly.v5.0.0"
      PURCHASE_KEYS_MAP.subscription_yearly = "co.polarr.ppe.desktop.subscribe.premium.all_platforms.yearly.v5.0.0"
      break
    case "windows":
      PURCHASE_KEYS_MAP.subscription_monthly = "co.polarr.ppe.desktop.subscribe.premium.all_platforms.monthly.v5.10.0"
      PURCHASE_KEYS_MAP.subscription_yearly = "co.polarr.ppe.desktop.subscribe.premium.all_platforms.yearly.v5.10.0"
      PURCHASE_KEYS_MAP.legacy_subscription_monthly =
        "co.polarr.ppe.desktop.subscribe.premium.all_platforms.monthly.v5.0.0"
      PURCHASE_KEYS_MAP.legacy_subscription_yearly =
        "co.polarr.ppe.desktop.subscribe.premium.all_platforms.yearly.v5.0.0"
      break
    case "android":
      PURCHASE_KEYS_MAP.subscription_monthly = "co.polarr.ppe.subscribe.premium.all_platforms.monthly.v5.10.0"
      PURCHASE_KEYS_MAP.subscription_yearly = "co.polarr.ppe.subscribe.premium.all_platforms.yearly.v5.10.0"
      PURCHASE_KEYS_MAP.legacy_subscription_monthly = "co.polarr.ppe.subscribe.premium.all_platforms.monthly.v5.0.0"
      PURCHASE_KEYS_MAP.legacy_subscription_yearly = "co.polarr.ppe.subscribe.premium.all_platforms.yearly.v5.0.0"
      break
  }

  window.splashScreen = {
    hide: function() {
      const splash = document.getElementById("splash")
      if (!splash) {
        return
      }
      setTimeout(
        function() {
          splash.style.opacity = 0
          setTimeout(function() {
            if (splash.parentNode) splash.parentNode.removeChild(splash)
          }, 300)
        },
        CONFIG.demoMode ? 2000 : 1
      )
    },
    setHTML: function(html) {
      const splash = document.getElementById("splash")
      if (!splash) {
        return
      }
      splash.innerHTML = html
    }
  }

  window.URLParams = {}
  var params = location.search ? location.search.split("?")[1].split("&") : []
  params.forEach(function(param) {
    var pair = decodeURIComponent(param).split("=")
    URLParams[pair[0]] = pair[1]
  })

  if (URLParams.debug) {
    CONFIG.debug = true
    ;(function() {
      var old = console.log
      var logger = document.createElement("pre")
      document.body.appendChild(logger)
      console.log = function() {
        for (var i = 0; i < arguments.length; i++) {
          if (typeof arguments[i] == "object") {
            logger.innerHTML +=
              (JSON && JSON.stringify ? JSON.stringify(arguments[i], undefined, 2) : arguments[i]) + "<br />"
          } else {
            logger.innerHTML += arguments[i] + "<br />"
          }
        }
      }
      console.error = console.log
    })()
  }

  /* ===== Disable contextmenu for IE and Chrome on Windows ===== */

  if (!CONFIG.debug && CONFIG.os !== "android") {
    window.document.body.addEventListener("contextmenu", function(e) {
      e.preventDefault()
    })
  }

  /* ===== Logging ===== */

  var isIPCLoaded = function() {
    return (
      typeof POIPCManager !== "undefined" &&
      (typeof window.ipcAndroid !== "undefined" || typeof window.webkit !== "undefined")
    )
  }

  var now = (function() {
    var _performance = window.performance || Date
    return function() {
      return _performance.now.apply(_performance)
    }
  })()

  const logTimes = {}

  window.logTime = function(name) {
    if (CONFIG.debug) {
      logTimes[name] = now()
    }
  }

  window.logTimeEnd = function(name) {
    if (CONFIG.debug) {
      var args = Array.prototype.slice.call(arguments)
      var time = (now() - logTimes[name]).toFixed(3)
      args[0] = name + ": " + time + "ms"
      if (isIPCLoaded()) alert(JSON.stringify(args))
      console.log.apply(console, args)
      // console.trace(...args)
    }
  }

  window.log = function() {
    var args = Array.prototype.slice.call(arguments)
    if (isIPCLoaded()) alert(JSON.stringify(args))
    console.log.apply(console, args)
    // console.trace(...args)
  }

  /* ===== Utility Functions ===== */

  var loadScript = function(src, load, error) {
    var script = document.createElement("script")
    script.src = src
    script.async = false
    script.onload = load
    script.onerror = error
    document.head.appendChild(script)
  }

  var createWorker = function(source) {
    var workerBlob = new Blob(["(" + source.toString() + "());"], { type: "text/javascript" })
    var workerURL = URL.createObjectURL(workerBlob)
    return new Worker(workerURL)
  }

  window.createWorker = createWorker

  var isWebGLSupported = function() {
    var canvas = document.createElement("canvas")

    var gl = canvas.getContext("webgl") || canvas.getContext("experimental-webgl")

    return gl !== null
  }

  /* ===== Scrips ===== */

  var loadScripts = function() {
    var scripts = CONFIG.scripts || []
    scripts.forEach(loadScript)
  }

  var openURL = function(url) {
    if (typeof Electron !== "undefined") {
      Electron.shell.openExternal(url)
    } else {
      window.open(url, "_blank")
    }
  }

  window.__updateDriver = function() {
    openURL("https://wiki.polarr.co/wiki/support/Driver-error.html")
  }

  var delay = CONFIG.embedded && CONFIG.debug ? 2000 : 0

  if (isWebGLSupported()) {
    setTimeout(loadScripts, delay)
  } else {
    splashScreen.setHTML(
      "<div class='error' style='font-family: sans-serif;'>" +
        "<h1 style='line-height: 1.5em; padding: 20px'>Sorry, there was an error with your device graphics. Please restart the app.</h1>" +
        "</div>"
    )
  }

  ;(function(p, l, o, w, i, n, g) {
    if (!p[i]) {
      p.GlobalSnowplowNamespace = p.GlobalSnowplowNamespace || []
      p.GlobalSnowplowNamespace.push(i)
      p[i] = function() {
        ;(p[i].q = p[i].q || []).push(arguments)
      }
      p[i].q = p[i].q || []
      n = l.createElement(o)
      g = l.getElementsByTagName(o)[0]
      n.async = 1
      n.src = w
      g.parentNode.insertBefore(n, g)
    }
  })(window, document, "script", "./js/sp.js", "snowplow")
})()
