precision mediump float;
varying vec2 vTexCoords;
uniform sampler2D y_tex;
uniform sampler2D u_tex;
uniform sampler2D v_tex;
uniform sampler2D rgb_tex;
uniform int yuv_enable;
uniform float bitDepth;
uniform mat3 mColorConversion;
uniform int rgb_enable;
void main() {
    vec3 yuv;
    vec4 yuvColor;
    vec4 rgbColor;
    if(yuv_enable == 0){
        gl_FragColor = texture2D(rgb_tex, vTexCoords);
        gl_FragColor.r = gl_FragColor.a * gl_FragColor.r;
        gl_FragColor.g = gl_FragColor.a * gl_FragColor.g;
        gl_FragColor.b = gl_FragColor.a * gl_FragColor.b;
        return;
    }
    if(bitDepth > 8.0){
        vec3 yuv_l;
        vec3 yuv_h;
        yuv_l.x = texture2D(y_tex, vTexCoords).r;
        yuv_h.x = texture2D(y_tex, vTexCoords).a;
        yuv_l.y = texture2D(u_tex, vTexCoords).r;
        yuv_h.y = texture2D(u_tex, vTexCoords).a;
        yuv_l.z = texture2D(v_tex, vTexCoords).r;
        yuv_h.z = texture2D(v_tex, vTexCoords).a;
        yuv = (yuv_l * 255.0 + yuv_h * 255.0 * 256.0) / pow(2.0, bitDepth) - vec3(0.0625, 0.5, 0.5);
    }else{
        yuv.x = texture2D(y_tex, vTexCoords).r - 0.0625;
        yuv.y = texture2D(u_tex, vTexCoords).r - 0.5;
        yuv.z = texture2D(v_tex, vTexCoords).r - 0.5;
    }
    yuvColor = vec4(mColorConversion * yuv, 1.0);
    if (rgb_enable == 0) {
        gl_FragColor = yuvColor;
        return;
    }
    rgbColor = texture2D(rgb_tex, vTexCoords);
    gl_FragColor = mix(rgbColor,yuvColor,(1.0 - rgbColor.a));
}