precision mediump float;
varying vec2 interp_tc;
uniform sampler2D y_tex;
uniform sampler2D u_tex;
uniform sampler2D v_tex;
uniform float bitDepth;
uniform mat3 mColorConversion;

uniform int uEnhanceQuality;
uniform float uContrastAdjust;
uniform float uBrightnessAdjust;
uniform float uSaturationAdjust;

void main() {
    vec3 yuv;
    if(bitDepth > 8.0){
        vec3 yuv_l;
        vec3 yuv_h;
        yuv_l.x = texture2D(y_tex, interp_tc).r;
        yuv_h.x = texture2D(y_tex, interp_tc).a;
        yuv_l.y = texture2D(u_tex, interp_tc).r;
        yuv_h.y = texture2D(u_tex, interp_tc).a;
        yuv_l.z = texture2D(v_tex, interp_tc).r;
        yuv_h.z = texture2D(v_tex, interp_tc).a;
        yuv = (yuv_l * 255.0 + yuv_h * 255.0 * 256.0) / pow(2.0, bitDepth) - vec3(0.0625, 0.5, 0.5);
    }else{
        yuv.x = texture2D(y_tex, interp_tc).r - 0.0625;
        yuv.y = texture2D(u_tex, interp_tc).r - 0.5;
        yuv.z = texture2D(v_tex, interp_tc).r - 0.5;
    }

    if (uEnhanceQuality == 1) {
        yuv.z = uContrastAdjust * yuv.z;
        yuv.y = uSaturationAdjust * yuv.y;
        // auto adjust brightness
        float diff = clamp(0.8 - yuv.x, 0.0, 0.5);
        float brightnessAdjust = uBrightnessAdjust + 0.1 * diff;
        yuv.x = clamp(yuv.x + brightnessAdjust, 0.0, 1.0);
    }

    gl_FragColor = vec4(mColorConversion * yuv, 1.0);

}