!function(e){var n={};function t(r){if(n[r])return n[r].exports;var i=n[r]={i:r,l:!1,exports:{}};return e[r].call(i.exports,i,i.exports,t),i.l=!0,i.exports}t.m=e,t.c=n,t.d=function(e,n,r){t.o(e,n)||Object.defineProperty(e,n,{configurable:!1,enumerable:!0,get:r})},t.r=function(e){Object.defineProperty(e,"__esModule",{value:!0})},t.n=function(e){var n=e&&e.__esModule?function(){return e.default}:function(){return e};return t.d(n,"a",n),n},t.o=function(e,n){return Object.prototype.hasOwnProperty.call(e,n)},t.p="",t(t.s="./src/main.js")}({"./src/bridgeMraid.js":function(module,exports,__webpack_require__){"use strict";eval('\n\n// Bridge interface to SDK\nvar CONSTANTS = __webpack_require__(/*! ./constants */ "./src/constants.js");\nvar Helpers = __webpack_require__(/*! ./helpers */ "./src/helpers.js");\nvar mraidState = __webpack_require__(/*! ./mraidState */ "./src/mraidState.js");\nvar log = __webpack_require__(/*! ./log */ "./src/log.js");\n\nvar nativeCallQueue = [];\nvar nativeCallInFlight = false;\nvar lastSizeChangeProperties = null;\nvar nativeSDKFiredReady = false;\nvar nativeInterface = null;\n\nfunction executeNativeCall(event, args) {\n    if (!nativeSDKFiredReady) {\n        console.log("Error: rejecting native call " + event + " because mraid is not ready"); // eslint-disable-line\n        return;\n    }\n    console.log("Info: Executing native call: " + event + " with args: " + Helpers.stringify(args)); // eslint-disable-line\n    // ios sdk\n    if (window.webkit && window.webkit.messageHandlers[event]) {\n        window.webkit.messageHandlers[event].postMessage(args);\n    } else {\n        // android sdk\n        var call = "smaato://" + event;\n        var isFirstArgument = true;\n        for (var propertyName in args) {\n            // eslint-disable-line no-restricted-syntax\n            if (args.hasOwnProperty(propertyName)) {\n                if (isFirstArgument) {\n                    call += "?";\n                    isFirstArgument = false;\n                } else {\n                    call += "&";\n                }\n                call += encodeURIComponent(propertyName) + "=" + encodeURIComponent(args[propertyName]);\n            }\n        }\n        if (nativeCallInFlight) {\n            nativeCallQueue.push(call);\n        } else {\n            nativeCallInFlight = true;\n            nativeCallExecutor(call);\n        }\n    }\n}\n\nfunction nativeCallComplete() {\n    // should be trigerred from sdk host\n    if (nativeCallQueue.length === 0) {\n        nativeCallInFlight = false;\n        return;\n    }\n    var nextCall = nativeCallQueue.pop();\n    nativeCallExecutor(nextCall);\n}\n\nfunction nativeCallExecutor(nextCall) {\n    if (nativeInterface === null) {\n        window.location = nextCall;\n    } else {\n        nativeInterface.call(nextCall);\n    }\n}\n\nfunction logNative(level, message, action) {\n    executeNativeCall("log", { level: level, message: message, action: action });\n}\n\nfunction setCurrentPosition(x, y, width, height) {\n    log.i("setCurrentPosition: " + x + ", " + y + ", " + width + ", " + height);\n    mraidState.updateCurrentPosition(x, y, width, height);\n}\n\nfunction setDefaultPosition(x, y, width, height) {\n    log.i("setDefaultPosition: " + x + ", " + y + ", " + width + ", " + height);\n    mraidState.updateDefaultPosition(x, y, width, height);\n}\n\nfunction setExpandProperties(width, height, isModal) {\n    log.i("setExpandProperties: " + width + ", " + height + ", " + isModal);\n    mraidState.updateExpandProperties("width", width);\n    mraidState.updateExpandProperties("height", height);\n    mraidState.updateExpandProperties("isModal", isModal);\n}\n\nfunction setResizeProperties(width, height, offsetX, offsetY, allowOffscreen) {\n    log.i("setResizeProperties: " + width + ", " + height + ", " + offsetX + ", " + offsetY + ", " + allowOffscreen);\n    var desiredProperties = ["width", "height", "offsetX", "offsetY", "allowOffscreen"];\n    var properties = {\n        width: width, height: height, offsetX: offsetX, offsetY: offsetY, allowOffscreen: allowOffscreen\n    };\n    mraidState.updateResizeProperties(desiredProperties, properties);\n}\n\nfunction setOrientationProperties(allowOrientationChange, forceOrientation) {\n    log.i("setOrientationProperties: " + allowOrientationChange + ", " + forceOrientation);\n    var desiredProperties = ["allowOrientationChange", "forceOrientation"];\n    var properties = {\n        allowOrientationChange: allowOrientationChange,\n        forceOrientation: forceOrientation\n    };\n    mraidState.updateOrientationProperties(desiredProperties, properties);\n}\n\nfunction setCurrentLocation(lat, lon, type, accuracy, lastfix, ipservice) {\n    log.i("setCurrentLocation " + lat + "," + lon + "," + type + "," + accuracy + "," + lastfix + "," + ipservice);\n    mraidState.updateCurrentLocation(lat, lon, type, accuracy, lastfix, ipservice);\n}\n\nfunction setCurrentAppOrientation(orientation, locked) {\n    log.i("setCurrentAppOrientation " + orientation + ", " + locked);\n    mraidState.updateCurrentOrientation(orientation, locked);\n}\n\nfunction setMaxSize(width, height) {\n    log.i("setMaxSize: " + width + ", " + height);\n    mraidState.updateMaxSize(width, height);\n    mraidState.updateExpandProperties("width", width);\n    mraidState.updateExpandProperties("height", height);\n}\n\nfunction setPlacementType(_placementType) {\n    log.i("setPlacementType: " + _placementType);\n    mraidState.updatePlacementType(_placementType);\n}\n\nfunction setScreenSize(width, height) {\n    log.i("setScreenSize: " + width + ", " + height);\n    mraidState.updateScreenSize(width, height);\n}\n\nfunction setIsViewable(_isViewable) {\n    log.i("setIsViewable: " + _isViewable);\n    var isViewable = mraidState.updateIsViewable(_isViewable);\n    broadcastEvent(CONSTANTS.EVENTS.VIEWABLECHANGE, isViewable);\n}\n\nfunction setSupports(feature, supported) {\n    log.i("setSupports " + feature + " " + supported);\n    return mraidState.updateSupportProperties(feature, supported);\n}\n\nfunction setNativeInterface(_nativeInterface) {\n    log.i("setNativeInterface " + _nativeInterface);\n    nativeInterface = _nativeInterface;\n}\n\n// EVENTS\n\nfunction fireReadyEvent() {\n    log.i("fireReadyEvent");\n    nativeSDKFiredReady = true;\n    broadcastEvent(CONSTANTS.EVENTS.READY);\n}\n\nfunction fireErrorEvent(message, action) {\n    log.i("fireErrorEvent " + message + " " + action);\n    broadcastEvent(CONSTANTS.EVENTS.ERROR, message, action);\n}\n\nfunction fireSizeChangeEvent(width, height) {\n    log.i("fireSizeChangeEvent " + width + ", " + height);\n    if (lastSizeChangeProperties && width === lastSizeChangeProperties.width && height === lastSizeChangeProperties.height) {\n        return;\n    }\n\n    lastSizeChangeProperties = {\n        width: width,\n        height: height\n    };\n    broadcastEvent(CONSTANTS.EVENTS.SIZECHANGE, width, height);\n}\n\nfunction fireStateChangeEvent(newState) {\n    log.i("fireStateChangeEvent " + newState);\n    if (newState === CONSTANTS.STATES.LOADING) {\n        log.i("Native SDK initialized.");\n    }\n    var state = mraidState.updateState(newState);\n    broadcastEvent(CONSTANTS.EVENTS.STATECHANGE, state);\n}\n\nfunction fireViewableChangeEvent(newIsViewable) {\n    log.i("fireViewableChangeEvent " + newIsViewable);\n    var isViewable = mraidState.getIsViewableValue();\n    if (isViewable !== newIsViewable) {\n        var updatedValue = mraidState.updateIsViewable(newIsViewable);\n        broadcastEvent(CONSTANTS.EVENTS.VIEWABLECHANGE, updatedValue);\n    }\n}\n\nfunction fireAudioVolumeChangeEvent(level) {\n    log.i("AudioVolume changed to " + level);\n    broadcastEvent(CONSTANTS.EVENTS.AUDIOVOLUMECHANGE, level);\n}\n\nfunction fireExposureChangeEvent(exposedPercentage, visibleRectangle, occlusionRectangles) {\n    log.i("fireExposureChangeEvent " + exposedPercentage + " visibleRectange " + visibleRectangle + " occlusionRectangles " + occlusionRectangles);\n    var exposureProperties = mraidState.getExposurePropertiesValues();\n    if (exposureProperties.exposedPercentage !== exposedPercentage || exposureProperties.visibleRectangle !== visibleRectangle || exposureProperties.occlusionRectangles !== occlusionRectangles) {\n        mraidState.updateExposureProperties("exposedPercentage", exposedPercentage);\n        mraidState.updateExposureProperties("visibleRectangle", visibleRectangle);\n        mraidState.updateExposureProperties("occlusionRectangles", occlusionRectangles);\n        broadcastEvent(CONSTANTS.EVENTS.EXPOSURECHANGE, exposedPercentage, visibleRectangle, occlusionRectangles);\n    }\n}\n\nfunction mraidLoaded() {\n    nativeSDKFiredReady = true;\n    executeNativeCall("mraidLoaded", {});\n}\n\nmodule.exports = {\n    setMaxSize: setMaxSize,\n    setSupports: setSupports,\n    setScreenSize: setScreenSize,\n    setIsViewable: setIsViewable,\n    setOrientationProperties: setOrientationProperties,\n    setCurrentAppOrientation: setCurrentAppOrientation,\n    setExpandProperties: setExpandProperties,\n    setResizeProperties: setResizeProperties,\n    setPlacementType: setPlacementType,\n    setCurrentPosition: setCurrentPosition,\n    setDefaultPosition: setDefaultPosition,\n    setCurrentLocation: setCurrentLocation,\n    fireSizeChangeEvent: fireSizeChangeEvent,\n    fireStateChangeEvent: fireStateChangeEvent,\n    fireViewableChangeEvent: fireViewableChangeEvent,\n    fireAudioVolumeChangeEvent: fireAudioVolumeChangeEvent,\n    fireExposureChangeEvent: fireExposureChangeEvent,\n    fireReadyEvent: fireReadyEvent,\n    fireErrorEvent: fireErrorEvent,\n    broadcastEvent: broadcastEvent,\n    executeNativeCall: executeNativeCall,\n    logNative: logNative,\n    mraidLoaded: mraidLoaded,\n    nativeCallQueue: nativeCallQueue,\n    nativeCallInFlight: nativeCallInFlight,\n    nativeCallComplete: nativeCallComplete,\n    setNativeInterface: setNativeInterface\n};\n\nfunction broadcastEvent() {\n    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n    }\n\n    var event = args.shift();\n    var listeners = mraidState.getListeners();\n    if (listeners[event]) {\n        listeners[event].broadcast(args);\n    }\n}\n\n//# sourceURL=webpack:///./src/bridgeMraid.js?')},"./src/constants.js":function(module,exports,__webpack_require__){"use strict";eval('\n\nmodule.exports = {\n    VERSION: "3.0",\n    STATES: {\n        LOADING: "loading",\n        DEFAULT: "default",\n        EXPANDED: "expanded",\n        HIDDEN: "hidden",\n        RESIZED: "resized"\n    },\n    EVENTS: {\n        ERROR: "error",\n        INFO: "info",\n        READY: "ready",\n        STATECHANGE: "stateChange",\n        VIEWABLECHANGE: "viewableChange",\n        SIZECHANGE: "sizeChange",\n        EXPOSURECHANGE: "exposureChange",\n        AUDIOVOLUMECHANGE: "audioVolumeChange"\n    },\n    PLACEMENT_TYPES: {\n        UNKNOWN: "unknown",\n        INLINE: "inline",\n        INTERSTITIAL: "interstitial"\n    },\n    NATIVE_EVENTS: {\n        OPEN: "open",\n        USECUSTOMCLOSE: "useCustomClose",\n        EXPAND: "expand",\n        CLOSE: "close",\n        UNLOAD: "unload",\n        PLAYVIDEO: "playVideo",\n        SETORIENTATIONPROPERTIES: "setOrientationProperties",\n        SETEXPANDPROPERTIES: "setExpandProperties",\n        RESIZE: "resize",\n        ADDEVENTLISTENER: "addEventListener",\n        REMOVEALLEVENTLISTENERS: "removeAllEventListeners"\n    },\n    ORIENTATION_PROPERTIES_ORIENTATION: {\n        PORTRAIT: "portrait",\n        LANDSCAPE: "landscape",\n        NONE: "none"\n    }\n};\n\n//# sourceURL=webpack:///./src/constants.js?')},"./src/helpers.js":function(module,exports,__webpack_require__){"use strict";eval('\n\nvar _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };\n\nfunction contains(value, array) {\n    for (var i in array) {\n        if (array[i] === value) {\n            return true;\n        }\n    }\n    return false;\n}\n\nfunction clone(obj) {\n    if (obj === null) {\n        return null;\n    }\n    var f = function f() {};\n    f.prototype = obj;\n    return new f();\n}\n\nfunction stringify(obj) {\n    if ((typeof obj === "undefined" ? "undefined" : _typeof(obj)) === "object") {\n        var out = [];\n        if (obj.push) {\n            // Array.\n            for (var p in obj) {\n                out.push(obj[p]);\n            }\n            return "[" + out.join(",") + "]";\n        }\n        // Other object.\n        for (var _p in obj) {\n            out.push("\'" + _p + "\': " + obj[_p]);\n        }\n        return "{" + out.join(",") + "}";\n    }return String(obj);\n}\n\nmodule.exports = {\n    clone: clone,\n    contains: contains,\n    stringify: stringify\n};\n\n//# sourceURL=webpack:///./src/helpers.js?')},"./src/log.js":function(module,exports,__webpack_require__){"use strict";eval('\n\nvar LogLevelEnum = {\n    Error: 1 << 0,\n    Warning: 1 << 1,\n    Info: 1 << 2,\n    Debug: 1 << 3,\n    Verbose: 1 << 4,\n    Private: 1 << 5\n};\n\nfunction logLevelToString(logLevel) {\n    switch (logLevel) {\n        case 1 << 0:\n            return "Error:";\n        case 1 << 1:\n            return "Warning:";\n        case 1 << 2:\n            return "Info:";\n        case 1 << 3:\n            return "Debug:";\n        case 1 << 4:\n            return "Verbose:";\n        case 1 << 5:\n            return "Private:";\n        default:\n            return "";\n    }\n}\n\nfunction logNative(level, msg) {\n    if (window.webkit && window.webkit.messageHandlers[event]) {\n        if (window.mraidbridge && window.mraidbridge.executeNativeCall) {\n            var message = { level: level, msg: msg };\n            window.mraidbridge.executeNativeCall("log", message);\n        } else {\n            console.log(logLevelToString(level) + ": " + msg); // eslint-disable-line\n        }\n    }\n}\n\nfunction e(msg) {\n    logNative(LogLevelEnum.Error, msg);\n}\n\nfunction w(msg) {\n    logNative(LogLevelEnum.Warning, msg);\n}\nfunction i(msg) {\n    logNative(LogLevelEnum.Info, msg);\n}\nfunction d(msg) {\n    logNative(LogLevelEnum.Debug, msg);\n}\nfunction v(msg) {\n    logNative(LogLevelEnum.Verbose, msg);\n}\nfunction p(msg) {\n    logNative(LogLevelEnum.Private, msg);\n}\n\nmodule.exports = {\n    e: e,\n    w: w,\n    i: i,\n    d: d,\n    v: v,\n    p: p\n};\n\n//# sourceURL=webpack:///./src/log.js?')},"./src/main.js":function(module,exports,__webpack_require__){"use strict";eval('\n\nvar mraid = __webpack_require__(/*! ./mraid */ "./src/mraid.js");\nvar mraidbridge = __webpack_require__(/*! ./bridgeMraid */ "./src/bridgeMraid.js");\nvar CONSTANTS = __webpack_require__(/*! ./constants */ "./src/constants.js");\nvar log = __webpack_require__(/*! ./log */ "./src/log.js");\n\n(function main() {\n    // Bridge interface to SDK\n    log.i("initializing mraid main.js");\n    window.mraidbridge = mraidbridge;\n    window.mraid = mraid;\n    mraid.addEventListener(CONSTANTS.EVENTS.ERROR, onError);\n    function onError(message, action) {\n        log.e("Error in " + action + " method: " + message);\n    }\n})();\n\n//# sourceURL=webpack:///./src/main.js?')},"./src/mraid.js":function(module,exports,__webpack_require__){"use strict";eval('\n\nvar CONSTANTS = __webpack_require__(/*! ./constants */ "./src/constants.js");\nvar Helpers = __webpack_require__(/*! ./helpers */ "./src/helpers.js");\nvar bridge = __webpack_require__(/*! ./bridgeMraid */ "./src/bridgeMraid.js");\nvar mraidState = __webpack_require__(/*! ./mraidState */ "./src/mraidState.js");\nvar log = __webpack_require__(/*! ./log */ "./src/log.js");\n\nvar VERSION = CONSTANTS.VERSION,\n    STATES = CONSTANTS.STATES,\n    EVENTS = CONSTANTS.EVENTS,\n    PLACEMENT_TYPES = CONSTANTS.PLACEMENT_TYPES,\n    NATIVE_EVENTS = CONSTANTS.NATIVE_EVENTS;\n\n\nmodule.exports = {\n    VERSION: VERSION,\n    STATES: STATES,\n    EVENTS: EVENTS,\n    PLACEMENT_TYPES: PLACEMENT_TYPES,\n    addEventListener: addEventListener,\n    removeEventListener: removeEventListener,\n    open: open,\n    close: close,\n    expand: expand,\n    resize: resize,\n    supports: supports,\n    playVideo: playVideo,\n    unload: unload,\n    getState: getState,\n    getMaxSize: getMaxSize,\n    getVersion: getVersion,\n    isViewable: isViewable,\n    getLocation: getLocation,\n    getScreenSize: getScreenSize,\n    useCustomClose: useCustomClose,\n    getPlacementType: getPlacementType,\n    getHostSDKVersion: getHostSDKVersion,\n    getCurrentPosition: getCurrentPosition,\n    getDefaultPosition: getDefaultPosition,\n    getResizeProperties: getResizeProperties,\n    setResizeProperties: setResizeProperties,\n    getExpandProperties: getExpandProperties,\n    setExpandProperties: setExpandProperties,\n    getOrientationProperties: getOrientationProperties,\n    setOrientationProperties: setOrientationProperties,\n    getCurrentAppOrientation: getCurrentAppOrientation\n};\n\nfunction addEventListener(event, listener) {\n    log.i("addEventListener \'" + event + "\' ");\n    if (!event || !listener) {\n        bridge.broadcastEvent(EVENTS.ERROR, "Both event and listener are required.", "addEventListener");\n    } else if (!Helpers.contains(event, EVENTS)) {\n        bridge.broadcastEvent(EVENTS.ERROR, "Unknown MRAID event: " + event, "addEventListener");\n    } else if (mraidState.updateListeners(event, listener)) {\n        var args = { event: event };\n        bridge.executeNativeCall(NATIVE_EVENTS.ADDEVENTLISTENER, args);\n    }\n}\n\nfunction close() {\n    log.i("mraid.close");\n    var state = mraidState.getStateValue();\n    if (state === STATES.LOADING || state === STATES.DEFAULT && getPlacementType() === PLACEMENT_TYPES.INLINE || state === STATES.HIDDEN) {\n        bridge.broadcastEvent(EVENTS.ERROR, "Ad cannot be closed from current state or placement type.", "close");\n    } else {\n        bridge.executeNativeCall(NATIVE_EVENTS.CLOSE, {});\n    }\n}\n\nfunction expand(url) {\n    var state = getState();\n    if (getPlacementType() !== PLACEMENT_TYPES.INLINE || state !== STATES.DEFAULT && state !== STATES.RESIZED) {\n        bridge.broadcastEvent(EVENTS.ERROR, "Ad can only be expanded from the default or resized state.", "expand");\n        return;\n    }\n    var args = {};\n    if (url) {\n        args = { url: url };\n    }\n    bridge.executeNativeCall(NATIVE_EVENTS.EXPAND, args);\n}\n\nfunction getLocation() {\n    log.i("getLocation");\n    return mraidState.getCurrentLocationValue();\n}\n\nfunction getExpandProperties() {\n    log.i("getExpandProperties");\n    var expandProperties = mraidState.getExpandPropertiesValues();\n    var properties = {\n        width: expandProperties.width,\n        height: expandProperties.height,\n        useCustomClose: expandProperties.useCustomClose,\n        isModal: expandProperties.isModal\n    };\n    return properties;\n}\n\nfunction getCurrentPosition() {\n    log.i("getCurrentPosition");\n\n    var _mraidState$getCurren = mraidState.getCurrentPositionValue(),\n        x = _mraidState$getCurren.x,\n        y = _mraidState$getCurren.y,\n        width = _mraidState$getCurren.width,\n        height = _mraidState$getCurren.height;\n\n    return {\n        x: x, y: y, width: width, height: height\n    };\n}\n\nfunction getDefaultPosition() {\n    log.i("getDefaultPosition");\n\n    var _mraidState$getDefaul = mraidState.getDefaultPositionValue(),\n        x = _mraidState$getDefaul.x,\n        y = _mraidState$getDefaul.y,\n        width = _mraidState$getDefaul.width,\n        height = _mraidState$getDefaul.height;\n\n    return {\n        x: x, y: y, width: width, height: height\n    };\n}\n\nfunction getMaxSize() {\n    var maxSize = mraidState.getMaxSizeValue();\n    log.i("getMaxSize " + maxSize.width + " x " + maxSize.height);\n    var width = maxSize.width,\n        height = maxSize.height;\n\n    return { width: width, height: height };\n}\n\nfunction getPlacementType() {\n    log.i("getPlacementType");\n    return mraidState.getPlacementTypeValue();\n}\n\nfunction getScreenSize() {\n    log.i("getScreenSize");\n    var screenSize = mraidState.getScreenSizeValue();\n    var width = screenSize.width,\n        height = screenSize.height;\n\n    return { width: width, height: height };\n}\n\nfunction getState() {\n    log.i("getState");\n    return mraidState.getStateValue();\n}\n\nfunction isViewable() {\n    log.i("isViewable");\n    return mraidState.getIsViewableValue();\n}\n\nfunction getVersion() {\n    log.i("getVersion");\n    return VERSION;\n}\n\nfunction open(url) {\n    log.i("open " + url);\n    if (!url) {\n        bridge.broadcastEvent(EVENTS.ERROR, "URL is required.", "open");\n    } else {\n        var args = { url: url };\n        bridge.executeNativeCall(NATIVE_EVENTS.OPEN, args);\n    }\n}\n\nfunction removeEventListener(event, listener) {\n    log.i("removeEventListener " + event + " : "); // + String(listener));\n    if (!event) {\n        bridge.broadcastEvent(EVENTS.ERROR, "Event is required.", "removeEventListener");\n        return;\n    }\n    var listeners = mraidState.getListeners();\n\n    if (listener) {\n        // If we have a valid event, we\'ll try to remove the listener from it.\n        var success = false;\n        if (listeners[event]) {\n            success = mraidState.removeListener(listener, event);\n        }\n        // If we didn\'t have a valid event or couldn\'t remove the listener from the event, broadcast an error and return early.\n        if (!success) {\n            bridge.broadcastEvent(EVENTS.ERROR, "Listener not currently registered for event.", "removeEventListener");\n            return;\n        }\n    } else if (!listener && listeners[event]) {\n        mraidState.removeAllListeners(event);\n    }\n\n    listeners = mraidState.getListeners();\n    if (listeners[event] && listeners[event].count === 0) {\n        mraidState.deleteListeners(event);\n        var args = { event: event };\n        bridge.executeNativeCall(NATIVE_EVENTS.REMOVEALLEVENTLISTENERS, args);\n    }\n}\n\nfunction setExpandProperties(properties) {\n    log.i("setExpandProperties");\n    if (validate(properties, "setExpandProperties")) {\n        // expandProperties contains 2 read-write properties: width, height,\n        // the isModal property is read-only\n        var rwProps = ["width", "height", "useCustomClose"];\n        for (var i = 0; i < rwProps.length; i += 1) {\n            var propname = rwProps[i];\n            if (properties.hasOwnProperty(propname)) {\n                mraidState.updateExpandProperties(propname, properties[propname]);\n            }\n        }\n        var expandProperties = mraidState.getExpandPropertiesValues();\n        bridge.executeNativeCall(NATIVE_EVENTS.SETEXPANDPROPERTIES, expandProperties);\n    }\n}\n\nfunction useCustomClose(shouldUseCustomClose) {\n    mraidState.updateExpandProperties("useCustomClose", shouldUseCustomClose);\n    var args = { shouldUseCustomClose: shouldUseCustomClose };\n    bridge.executeNativeCall(NATIVE_EVENTS.USECUSTOMCLOSE, args);\n}\n\nfunction supports(feature) {\n    var supported = mraidState.getSupportValue(feature);\n    log.i("supports " + feature + " " + supported);\n    return supported;\n}\n\nfunction unload() {\n    log.i("unload");\n    bridge.executeNativeCall(NATIVE_EVENTS.UNLOAD, {});\n}\n\nfunction playVideo(uri) {\n    log.i("playVideo " + uri);\n    if (!isViewable()) {\n        bridge.broadcastEvent(EVENTS.ERROR, "playVideo cannot be called until the ad is viewable", "playVideo");\n        return;\n    }\n    if (!uri) {\n        bridge.broadcastEvent(EVENTS.ERROR, "playVideo must be called with a valid URI", "playVideo");\n    } else {\n        var args = { uri: uri };\n        bridge.executeNativeCall(NATIVE_EVENTS.PLAYVIDEO, args);\n    }\n}\n\nfunction setOrientationProperties(properties) {\n    log.i("setOrientationProperties");\n    var desiredProperties = ["allowOrientationChange", "forceOrientation"];\n    var orientationProperties = mraidState.updateOrientationProperties(desiredProperties, properties);\n\n    var args = {\n        allowOrientationChange: orientationProperties.allowOrientationChange,\n        forceOrientation: orientationProperties.forceOrientation\n    };\n    bridge.executeNativeCall(NATIVE_EVENTS.SETORIENTATIONPROPERTIES, args);\n}\n\nfunction getOrientationProperties() {\n    log.i("getOrientationProperties");\n\n    var _mraidState$getOrient = mraidState.getOrientationPropertiesValues(),\n        allowOrientationChange = _mraidState$getOrient.allowOrientationChange,\n        forceOrientation = _mraidState$getOrient.forceOrientation;\n\n    return {\n        allowOrientationChange: allowOrientationChange,\n        forceOrientation: forceOrientation\n    };\n}\n\nfunction getCurrentAppOrientation() {\n    log.i("getCurrentAppOrientation");\n    var currentAppOrientation = mraidState.getCurrentAppOrientationValues();\n    var orientation = currentAppOrientation.orientation,\n        locked = currentAppOrientation.locked;\n\n    return { orientation: orientation, locked: locked };\n}\n\nfunction resize() {\n    log.i("resize");\n\n    if (getPlacementType() === PLACEMENT_TYPES.INTERSTITIAL || !(getState() === STATES.DEFAULT || getState() === STATES.RESIZED)) {\n        bridge.broadcastEvent(EVENTS.ERROR, "Ad can only be resized from the default or resized state.", "resize");\n        return;\n    }\n\n    var _mraidState$getResize = mraidState.getResizePropertiesValues(),\n        width = _mraidState$getResize.width,\n        height = _mraidState$getResize.height;\n\n    if (!width || !height) {\n        bridge.broadcastEvent(EVENTS.ERROR, "Must set resize properties before calling resize()", "resize");\n        return;\n    }\n    bridge.executeNativeCall(NATIVE_EVENTS.RESIZE, {});\n}\n\nfunction getResizeProperties() {\n    log.i("getResizeProperties");\n\n    var _mraidState$getResize2 = mraidState.getResizePropertiesValues(),\n        width = _mraidState$getResize2.width,\n        height = _mraidState$getResize2.height,\n        offsetX = _mraidState$getResize2.offsetX,\n        offsetY = _mraidState$getResize2.offsetY,\n        allowOffscreen = _mraidState$getResize2.allowOffscreen;\n\n    var properties = {\n        width: width,\n        height: height,\n        offsetX: offsetX,\n        offsetY: offsetY,\n        allowOffscreen: allowOffscreen\n    };\n    return properties;\n}\n\nfunction setResizeProperties(properties) {\n    log.i("setResizeProperties");\n\n    mraidState.isResizeReady = false;\n    var currentResizeProperties = mraidState.getResizePropertiesValues();\n    // resizeProperties contains 6 read-write properties:\n    // width, height, offsetX, offsetY, allowOffscreen\n\n    // The properties object passed into this function must contain width, height, offsetX, offsetY.\n    // The remaining two properties are optional.\n    var requiredProps = ["width", "height", "offsetX", "offsetY"];\n    for (var i = 0; i < requiredProps.length; i += 1) {\n        var propname = requiredProps[i];\n        if (!properties.hasOwnProperty(propname)) {\n            bridge.broadcastEvent(EVENTS.ERROR, "required property " + propname + " is missing", "setResizeProperties");\n            return;\n        }\n    }\n\n    if (!validate(properties, "setResizeProperties")) {\n        bridge.broadcastEvent(EVENTS.ERROR, "failed validation", "setResizeProperties");\n        return;\n    }\n\n    var adjustments = { x: 0, y: 0 };\n\n    var allowOffscreen = properties.hasOwnProperty("allowOffscreen") ? properties.allowOffscreen : currentResizeProperties.allowOffscreen;\n    if (!allowOffscreen) {\n        var maxSize = mraidState.getMaxSizeValue();\n        if (properties.width > maxSize.width || properties.height > maxSize.height) {\n            bridge.broadcastEvent(EVENTS.ERROR, "resize width or height is greater than the maxSize width or height", "setResizeProperties");\n            return;\n        }\n        adjustments = fitResizeViewOnScreen(properties);\n    }\n\n    var rwProps = ["width", "height", "offsetX", "offsetY", "allowOffscreen"];\n    mraidState.updateResizeProperties(rwProps, properties);\n\n    var adjustedProperties = properties;\n    adjustedProperties.offsetX += adjustments.x;\n    adjustedProperties.offsetY += adjustments.y;\n\n    bridge.executeNativeCall("setResizeProperties", adjustedProperties);\n    mraidState.isResizeReady = true;\n}\n\nfunction fitResizeViewOnScreen(properties) {\n    var defaultPosition = mraidState.getDefaultPositionValue();\n    var resizeRect = {};\n    var maxSize = mraidState.getMaxSizeValue();\n\n    log.d("fitResizeViewOnScreen");\n    log.d("defaultPosition " + defaultPosition.x + " " + defaultPosition.y);\n    log.d("offset " + properties.offsetX + " " + properties.offsetY);\n\n    resizeRect.x = defaultPosition.x + properties.offsetX;\n    resizeRect.y = defaultPosition.y + properties.offsetY;\n    resizeRect.width = properties.width;\n    resizeRect.height = properties.height;\n\n    var maxRect = { x: 0, y: 0 };\n    maxRect.width = maxSize.width;\n    maxRect.height = maxSize.height;\n\n    var adjustments = { x: 0, y: 0 };\n\n    if (isRectContained(maxRect, resizeRect)) {\n        log.d("no adjustment necessary");\n        return adjustments;\n    }\n\n    if (resizeRect.x < maxRect.x) {\n        adjustments.x = maxRect.x - resizeRect.x;\n    } else if (resizeRect.x + resizeRect.width > maxRect.x + maxRect.width) {\n        adjustments.x = maxRect.x + maxRect.width - (resizeRect.x + resizeRect.width);\n    }\n    log.d("adjustments.x " + adjustments.x);\n\n    if (resizeRect.y < maxRect.y) {\n        adjustments.y = maxRect.y - resizeRect.y;\n    } else if (resizeRect.y + resizeRect.height > maxRect.y + maxRect.height) {\n        adjustments.y = maxRect.y + maxRect.height - (resizeRect.y + resizeRect.height);\n    }\n    log.d("adjustments.y " + adjustments.y);\n\n    resizeRect.x = defaultPosition.x + properties.offsetX + adjustments.x;\n    resizeRect.y = defaultPosition.y + properties.offsetY + adjustments.y;\n    printRect("adjusted resizeRect", resizeRect);\n\n    return adjustments;\n}\n\nfunction isRectContained(containingRect, containedRect) {\n    return containedRect.x >= containingRect.x && containedRect.x + containedRect.width <= containingRect.x + containingRect.width && containedRect.y >= containingRect.y && containedRect.y + containedRect.height <= containingRect.y + containingRect.height;\n}\n\nfunction printRect(label, rect) {\n    log.d(label + " [" + rect.x + "," + rect.y + "]" + (",[" + (rect.x + rect.width) + "," + (rect.y + rect.height) + "]") + (" (" + rect.width + "x" + rect.height + ")"));\n}\n\n// Determining SDK version\nfunction getHostSDKVersion() {\n    return mraidState.getHostSDKVersionValue();\n}\n\nvar allValidators = {\n    setExpandProperties: {\n        width: function width(_width) {\n            return !Number.isNaN(_width);\n        },\n        height: function height(_height) {\n            return !Number.isNaN(_height);\n        }\n    },\n    setOrientationProperties: {\n        allowOrientationChange: function allowOrientationChange(_allowOrientationChange) {\n            return typeof _allowOrientationChange === "boolean";\n        },\n        forceOrientation: function forceOrientation(_forceOrientation) {\n            var validValues = ["portrait", "landscape", "none"];\n            return validValues.indexOf(_forceOrientation) !== -1;\n        }\n    },\n    setResizeProperties: {\n        width: function width(_width2) {\n            return !Number.isNaN(_width2) && _width2 >= 0;\n        },\n        height: function height(_height2) {\n            return !Number.isNaN(_height2) && _height2 >= 0;\n        },\n        offsetX: function offsetX(_offsetX) {\n            return !Number.isNaN(_offsetX);\n        },\n        offsetY: function offsetY(_offsetY) {\n            return !Number.isNaN(_offsetY);\n        },\n        allowOffscreen: function allowOffscreen(_allowOffscreen) {\n            return typeof _allowOffscreen === "boolean";\n        }\n    }\n};\n\nfunction validate(properties, action) {\n    var retval = true;\n    var validators = allValidators[action];\n    for (var prop in properties) {\n        // eslint-disable-line no-restricted-syntax\n        if (properties.hasOwnProperty(prop)) {\n            var validator = validators[prop];\n            var value = properties[prop];\n            if (validator && !validator(value)) {\n                bridge.broadcastEvent(CONSTANTS.EVENTS.ERROR, "Value of property " + prop + " is invalid: " + value, action);\n                retval = false;\n            }\n        }\n    }\n    return retval;\n}\n\n//# sourceURL=webpack:///./src/mraid.js?')},"./src/mraidState.js":function(module,exports,__webpack_require__){"use strict";eval('\n\nvar CONSTANTS = __webpack_require__(/*! ./constants */ "./src/constants.js");\n\n// internal MRAID state\nvar state = "loading";\nvar isViewable = false;\nvar placementType = "unknown";\nvar hostSDKVersion = {\n    major: 0,\n    minor: 0,\n    patch: 0\n};\nvar defaultPosition = {};\nvar currentPosition = {};\nvar maxSize = {};\nvar screenSize = {};\nvar isResizeReady = false;\n\n// External MRAID state: may be directly or indirectly modified by the ad JS.\n// Properties which define the behavior of an expandable ad.\nvar expandProperties = {\n    width: false,\n    height: false,\n    useCustomClose: false,\n    isModal: true\n};\n\nvar resizeProperties = {\n    width: false,\n    height: false,\n    offsetX: false,\n    offsetY: false,\n    allowOffscreen: true\n};\n\nvar orientationProperties = {\n    allowOrientationChange: true,\n    forceOrientation: "none"\n};\n\nvar currentOrientation = {\n    orientation: CONSTANTS.ORIENTATION_PROPERTIES_ORIENTATION.NONE,\n    locked: false\n};\n\nvar supportProperties = {};\n\nvar currentLocation = {\n    lat: -1,\n    lon: -1,\n    type: 1,\n    accuracy: 0,\n    lastfix: 0,\n    ipservice: ""\n};\n\nvar exposureProperties = {\n    exposedPercentage: 0,\n    visibleRectangle: {},\n    occlusionRectangles: {}\n};\n\nvar eventListeners = {};\n\nfunction getListeners() {\n    return eventListeners;\n}\n\nfunction getResizePropertiesValues() {\n    return resizeProperties;\n}\n\nfunction getOrientationPropertiesValues() {\n    return orientationProperties;\n}\n\nfunction getCurrentAppOrientationValues() {\n    return currentOrientation;\n}\n\nfunction getStateValue() {\n    return state;\n}\n\nfunction getSupportValue(feature) {\n    var retval = supportProperties[feature];\n    if (typeof retval === "undefined") {\n        retval = false;\n    }\n    return retval;\n}\n\nfunction getMaxSizeValue() {\n    return maxSize;\n}\n\nfunction getExpandPropertiesValues() {\n    return expandProperties;\n}\n\nfunction getScreenSizeValue() {\n    return screenSize;\n}\n\nfunction getPlacementTypeValue() {\n    return placementType;\n}\n\nfunction getIsViewableValue() {\n    return isViewable;\n}\n\nfunction getHostSDKVersionValue() {\n    return hostSDKVersion;\n}\n\nfunction getDefaultPositionValue() {\n    return defaultPosition;\n}\n\nfunction getCurrentPositionValue() {\n    return currentPosition;\n}\n\nfunction getExposurePropertiesValues() {\n    return exposureProperties;\n}\n\nfunction getCurrentLocationValue() {\n    if (currentLocation.lat === -1 && currentLocation.lon === -1) {\n        return "-1";\n    }\n    return currentLocation;\n}\n\nfunction updateState(value) {\n    state = value;\n    return state;\n}\n\nfunction updateMaxSize(width, height) {\n    maxSize = { width: width, height: height };\n    return maxSize;\n}\n\nfunction updateIsViewable(value) {\n    isViewable = value;\n    return isViewable;\n}\n\nfunction updateScreenSize(width, height) {\n    screenSize = { width: width, height: height };\n    return screenSize;\n}\n\nfunction updateExpandProperties(key, value) {\n    expandProperties[key] = value;\n    return expandProperties;\n}\n\nfunction updateSupportProperties(feature, supported) {\n    supportProperties[feature] = supported;\n    return supportProperties;\n}\n\nfunction updatePlacementType(value) {\n    placementType = value;\n    return placementType;\n}\n\nfunction updateHostSDKVersion(versions) {\n    hostSDKVersion.major = parseInt(versions[0], 10);\n    hostSDKVersion.minor = parseInt(versions[1], 10);\n    hostSDKVersion.patch = parseInt(versions[2], 10);\n    return hostSDKVersion;\n}\n\nfunction updateResizeProperties(desiredProperties, properties) {\n    desiredProperties.forEach(function (propertyName) {\n        if (properties.hasOwnProperty(propertyName)) {\n            resizeProperties[propertyName] = properties[propertyName];\n        }\n    });\n    return resizeProperties;\n}\n\nfunction updateDefaultPosition(x, y, width, height) {\n    defaultPosition = {\n        x: x, y: y, width: width, height: height\n    };\n    return defaultPosition;\n}\n\nfunction updateCurrentPosition(x, y, width, height) {\n    currentPosition = {\n        x: x, y: y, width: width, height: height\n    };\n    return currentPosition;\n}\n\nfunction updateOrientationProperties(desiredProperties, properties) {\n    desiredProperties.forEach(function (propertyName) {\n        if (properties.hasOwnProperty(propertyName)) {\n            orientationProperties[propertyName] = properties[propertyName];\n        }\n    });\n    return orientationProperties;\n}\n\nfunction updateCurrentOrientation(orientation, locked) {\n    currentOrientation.orientation = orientation;\n    currentOrientation.locked = locked;\n    return currentOrientation;\n}\n\nfunction updateExposureProperties(key, value) {\n    exposureProperties[key] = value;\n    return exposureProperties;\n}\n\nfunction updateCurrentLocation(lat, lon, type, accuracy, lastfix, ipservice) {\n    currentLocation = {\n        lat: lat, lon: lon, type: type, accuracy: accuracy, lastfix: lastfix, ipservice: ipservice\n    };\n    return currentLocation;\n}\n\nfunction updateListeners(event, listener) {\n    if (!eventListeners[event]) {\n        eventListeners[event] = new EventListeners(event); // eslint-disable-line\n    }\n    return eventListeners[event].add(listener);\n}\n\nfunction removeListener(listener, event) {\n    return eventListeners[event].remove(listener);\n}\n\nfunction removeAllListeners(event) {\n    return eventListeners[event].removeAll();\n}\n\nfunction deleteListeners(event) {\n    eventListeners[event] = null;\n    delete eventListeners[event];\n}\n\nmodule.exports = {\n    getListeners: getListeners,\n    removeListener: removeListener,\n    deleteListeners: deleteListeners,\n    updateListeners: updateListeners,\n    removeAllListeners: removeAllListeners,\n    getStateValue: getStateValue,\n    getSupportValue: getSupportValue,\n    getMaxSizeValue: getMaxSizeValue,\n    getIsViewableValue: getIsViewableValue,\n    getScreenSizeValue: getScreenSizeValue,\n    getExpandPropertiesValues: getExpandPropertiesValues,\n    getPlacementTypeValue: getPlacementTypeValue,\n    getHostSDKVersionValue: getHostSDKVersionValue,\n    getCurrentPositionValue: getCurrentPositionValue,\n    getDefaultPositionValue: getDefaultPositionValue,\n    getResizePropertiesValues: getResizePropertiesValues,\n    getOrientationPropertiesValues: getOrientationPropertiesValues,\n    getCurrentAppOrientationValues: getCurrentAppOrientationValues,\n    getExposurePropertiesValues: getExposurePropertiesValues,\n    getCurrentLocationValue: getCurrentLocationValue,\n    updateState: updateState,\n    updateMaxSize: updateMaxSize,\n    updateIsViewable: updateIsViewable,\n    updateScreenSize: updateScreenSize,\n    updatePlacementType: updatePlacementType,\n    updateHostSDKVersion: updateHostSDKVersion,\n    updateDefaultPosition: updateDefaultPosition,\n    updateCurrentPosition: updateCurrentPosition,\n    updateResizeProperties: updateResizeProperties,\n    updateExpandProperties: updateExpandProperties,\n    updateSupportProperties: updateSupportProperties,\n    updateOrientationProperties: updateOrientationProperties,\n    updateCurrentOrientation: updateCurrentOrientation,\n    updateExposureProperties: updateExposureProperties,\n    updateCurrentLocation: updateCurrentLocation,\n    isResizeReady: isResizeReady\n};\n\nfunction EventListeners(event) {\n    this.event = event;\n    this.count = 0;\n    var listeners = {};\n\n    this.add = function (func) {\n        var id = String(func);\n        if (!listeners[id]) {\n            listeners[id] = func;\n            this.count = this.count + 1;\n            return true;\n        }\n        return false;\n    };\n\n    this.remove = function (func) {\n        var id = String(func);\n        if (listeners[id]) {\n            listeners[id] = null;\n            delete listeners[id];\n            this.count = this.count - 1;\n            return true;\n        }\n        return false;\n    };\n\n    this.removeAll = function () {\n        for (var id in listeners) {\n            if (listeners.hasOwnProperty(id)) {\n                this.remove(listeners[id]);\n            }\n        }\n    };\n\n    this.broadcast = function (args) {\n        for (var id in listeners) {\n            if (listeners[id]) {\n                listeners[id].apply(window.mraid, args);\n            }\n        }\n    };\n\n    this.toString = function () {\n        var out = [event, ":"];\n        for (var id in listeners) {\n            if (listeners.hasOwnProperty(id)) {\n                out.push("|", id, "|");\n            }\n        }\n        return out.join("");\n    };\n}\n\n//# sourceURL=webpack:///./src/mraidState.js?')}});