#version 100
precision mediump float;

// Input attributes
attribute vec2 a_Position;
attribute vec2 a_Velocity;
attribute float a_Life;
attribute float a_ModPhase;
attribute float a_ModFreq; 
attribute float a_ModAmp;
attribute float a_SizeScale;

// Uniforms
uniform vec2 u_Resolution;
uniform float u_Time;
uniform vec2 u_TouchPosition;
uniform float u_ParticleSize;
uniform vec4 u_Color;
uniform vec4 u_AccentColor;
uniform mediump float u_TransitionTime;
uniform mediump int u_State;
uniform mediump int u_PrevState;
uniform int u_IsTouching;
uniform float u_AudioReactivity;
uniform float u_AudioReactivityMultiplier;

// Varying outputs
varying float v_Life;
varying float v_ModPhase;

void main() {
  // Convert position to clip space
  vec2 clipSpace = (a_Position / u_Resolution) * 2.0 - 1.0;
  clipSpace.y = -clipSpace.y;  // Invert Y coordinate
  gl_Position = vec4(clipSpace, 0.0, 1.0);
  
  // Calculate size scale based on transition states
  float transitionDuration = 0.5;
  float transitionProgress = min(u_TransitionTime / transitionDuration, 1.0);
  float sizeScale = 1.0;
  
  // Transition logic
  if (u_State == 0 && u_PrevState != 0) {  // entry state
    sizeScale = mix(1.0, 0.75, transitionProgress);
  } else if (u_State != 0 && u_PrevState == 0) {
    sizeScale = mix(0.75, 1.0, transitionProgress);
  } else if (u_State == 0 && u_PrevState == 0) {
    sizeScale = 0.75;
  }
  
  // Calculate final point size
  gl_PointSize = u_ParticleSize * a_SizeScale * sizeScale;
  
  // Pass values to fragment shader
  v_Life = a_Life;
  v_ModPhase = a_ModPhase;
} 