precision highp float;

varying vec2 uTexCoord;

uniform sampler2D uTexture;

uniform float uDistortion;  // [0.0, 1.0]
uniform float uDirection;
uniform float uNScale;
uniform float uNSpeed;
uniform float uAspectRatio;
uniform int uComplexity;

uniform float uTime;
uniform vec2 uResolution;

#define PI 3.1415926535898


vec2 random(vec2 st) {
    st = vec2(dot(st, vec2(17.134,21.729)), dot(st, vec2(69.5,83.3)));
    return -1.0 + 2.0 * fract(sin(st) * 67345.56746541);
}

vec2 gradientNoise(vec2 st) {
    vec2 i = floor(st);
    vec2 f = fract(st);

    vec2 u = f * f * (3.0 - 2.0 * f);
    return mix( mix( random(i + vec2(0.0,0.0)), random(i + vec2(1.0,0.0)), u.x ),
                mix( random(i + vec2(0.0,1.0)), random(i + vec2(1.0,1.0)), u.x ), u.y );
}

vec2 fbm(vec2 st, vec2 fbmOff) {
    vec2 value = vec2(0.0);
    st.x *= uAspectRatio ;
    st *= uNScale;

    float amplitude = 0.4;
    float frequency = 2.39;
    float gain = 0.699;

    float a95 = 0.0 * PI / 180.0;
    mat2 rot = mat2(cos(a95), sin(a95),
                   -sin(a95), cos(a95));

    for (int i = 0; i < uComplexity; i++) {
        vec2 temp = st + fbmOff;
        vec2 r = gradientNoise(temp);
        value += amplitude * r;
        st = rot * st * frequency;
        fbmOff *= frequency * 0.6;
        amplitude *= gain;
    }
    return value;
}

void main() {
    vec2 st = uTexCoord;
    float time = mod(uTime, 10000.0);

    float dir = uDirection * PI / 180.0;
    vec2 rot = vec2(-cos(dir), -sin(dir));
    vec2 offset = rot * time * uNSpeed;
    vec2 pos = st + fbm(st + offset * 0.001, offset * vec2(0.01, 0.0102)) * uDistortion;

    gl_FragColor = texture2D(uTexture, pos);
}
