
precision highp float;
varying highp vec2 textureCoordinate;
varying highp vec2 textureCoordinate2;
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;

void main()
{
    highp vec4 baseColor=texture2D(inputImageTexture, textureCoordinate);
    highp vec4 blendColor=texture2D(inputImageTexture2, textureCoordinate);
    highp vec4 resultColor=vec4(baseColor);

    float blendFactor = baseColor.a * blendColor.a;
    float baseFactor = 1.0 - blendFactor;
    if(blendColor.a < 1.0) {
        resultColor.rgb = mix(baseColor.rgb, blendColor.rgb, blendFactor);
    } else {
        resultColor = blendColor;
    }

    if (resultColor.r > resultColor.a) {
        resultColor.r = resultColor.a;
    }
    if (resultColor.g > resultColor.a) {
        resultColor.g = resultColor.a;
    }
    if (resultColor.b > resultColor.a) {
        resultColor.b = resultColor.a;
    }

    gl_FragColor=resultColor;
}