precision highp float;
varying highp vec2 textureCoordinate;
varying highp vec2 textureCoordinate2;
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform vec4 hairColor;

vec4 unpremultiply(vec4 s) {
    return vec4(s.rgb/max(s.a, 0.00001), s.a);
}

vec4 premultiply(vec4 s) {
    return vec4(s.rgb * s.a, s.a);
}

vec4 normalBlend(vec4 Cb, vec4 Cs) {
    vec4 dst = premultiply(Cb);
    vec4 src = premultiply(Cs);
    return unpremultiply(src + dst * (1.0 - src.a));
}

vec4 normalBlendNoPremultiply(vec4 Cb, vec4 Cs) {
    vec4 dst = (Cb);
    vec4 src = (Cs);
    return unpremultiply(src + dst * (1.0 - src.a));
}

vec3 saturate(vec3 rgb) {
    return clamp(rgb, vec3(0.0), vec3(1.0));
}

vec4 saturate2(lowp vec4 v) {
    return clamp(v, 0.0, 1.0);
}

vec4 blendBaseAlpha(vec4 Cb, vec4 Cs, vec4 B) {
    vec4 Cr = vec4((1.0 - Cb.a) * Cs.rgb + Cb.a * saturate(B.rgb), Cs.a);
    return normalBlend(Cb, Cr);
}

// add also linearDodge
vec4 addBlend(vec4 Cb, vec4 Cs) {
    vec4 B = min(Cb + Cs, 1.0);
    return blendBaseAlpha(Cb, Cs, B);
}

// multiply
vec4 multiplyBlend(vec4 Cb, vec4 Cs) {
    vec4 B = saturate2(vec4(Cb.rgb * Cs.rgb, Cs.a));
    return blendBaseAlpha(Cb, Cs, B);
}

vec4 screenBlend(vec4 Cb, vec4 Cs) {
    vec4 White = vec4(1.0);
    vec4 B = White - ((White - Cs) * (White - Cb));
    return blendBaseAlpha(Cb, Cs, B);
}

void main()
{
    vec4 gaussianBlurColor = texture2D(inputImageTexture, textureCoordinate);
    vec4 maskColor = texture2D(inputImageTexture2, textureCoordinate2);
    if (maskColor.a <=0.0){
        gl_FragColor = vec4(0., 0., 0., 0.);
    } else {
        float alpha =  hairColor.a * maskColor.a;
        gl_FragColor = normalBlend(gaussianBlurColor, vec4(hairColor.rgb,alpha));
    }
}