precision highp float;

attribute vec2 aPosition;
attribute vec2 aTexCoord;

varying float uProgress;
varying float uDistance;
varying vec2 vPos;

uniform vec3 uPosTran;

void main() {
    vec2 pos = (aPosition.xy + uPosTran.z) / uPosTran.xy;
    pos = pos * 2.0 - 1.0;
    pos = aPosition;
    vPos = pos;
    gl_PointSize = 5.0;
    gl_Position = vec4(pos.x, pos.y, 1.0, 1.0);
    uProgress = aTexCoord.x;
    uDistance = aTexCoord.y;
}
