
precision highp float;
varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;

uniform vec2 inputSize;

void main()
{
    float step = 6.0;
    vec2  uvOffsets[25];
    float dx = step / inputSize.x;
    float dy = step / inputSize.y;

    for (int i = 0; i < 5; i++) {
        for (int j = 0; j < 5; j++) {
            uvOffsets[((i*5)+j)].x = (-2.0 * dx) + (float(i) * dx);
            uvOffsets[((i*5)+j)].y = (-2.0 * dy) + (float(j) * dy);
        }
    }

    vec4 result = vec4(1.0);
    for (int i = 0; i < 25; i++) {
        vec4 col = texture2D(inputImageTexture, textureCoordinate + uvOffsets[i]);
        result = min(result, col);
    }

    // 输出最终颜色
    gl_FragColor = result;
}