precision highp float;
varying highp vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;

uniform vec4 trackColor;
uniform float alpha;

void main() {
    vec4 maskColor = texture2D(inputImageTexture2, textureCoordinate);
    vec4 srcColor = texture2D(inputImageTexture, textureCoordinate);

    vec4 dest=trackColor*maskColor.a*0.6 * alpha;
    vec4 temp=dest*srcColor.a;
    gl_FragColor = srcColor*(1.-temp.a)+temp;

}