precision highp float;
varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform mat4 mBlendMatrix;
uniform int needLager;

void main()
{
    vec4 coordinate=vec4(textureCoordinate, 0., 1.);
    coordinate= mBlendMatrix * coordinate;


    vec4 outlineColor;
    vec4 srcColor;
    if (needLager == 1){
        if (coordinate.x<0.||coordinate.x>1.||coordinate.y<0.||coordinate.y>1.){
            srcColor = vec4(0., 0., 0., 0.);
        } else {
            srcColor = texture2D(inputImageTexture, coordinate.xy);
        }
        outlineColor=texture2D(inputImageTexture2, textureCoordinate.xy);
        gl_FragColor = outlineColor  * (1.0-srcColor.a)+ srcColor;
    } else {
        if (coordinate.x<0.||coordinate.x>1.||coordinate.y<0.||coordinate.y>1.){
            gl_FragColor =vec4(0., 0., 0., 0.);
        } else {
            srcColor=texture2D(inputImageTexture, coordinate.xy);
            outlineColor=texture2D(inputImageTexture2, coordinate.xy);
            gl_FragColor = outlineColor  * (1.0-srcColor.a)+ srcColor;
        }

    }


}