
precision highp float;
varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;// 已经裁剪的纹理
uniform sampler2D inputImageTexture2;// 背景纹理
uniform mat4 mBgMatrix;

void main()
{
    vec4 srcColor=texture2D(inputImageTexture, textureCoordinate);
    vec4 mBgColor = vec4(.0);
    vec4 bgCoordinate=vec4(textureCoordinate, 0., 1.);
    bgCoordinate= mBgMatrix * bgCoordinate;
    if (bgCoordinate.x>=0.&&bgCoordinate.x<=1.&&bgCoordinate.y>=0.&&bgCoordinate.y<=1.){
        mBgColor=texture2D(inputImageTexture2, bgCoordinate.xy);
    }
    vec3 resultColor = mBgColor.rgb* (1.0 - srcColor.a) + srcColor.rgb;
    gl_FragColor= vec4(resultColor, mBgColor.a * (1.0 - srcColor.a) + srcColor.a);;
}