////// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;

varying highp vec2 textureCoordinate2;
uniform sampler2D inputImageTexture2;

uniform mat4 uMVPMatrix;

uniform float enhancePercent;

uniform int showAllEnhancedEffects;

void main() {
    bool isEnhance = false;
    if (textureCoordinate.x > enhancePercent) {
        isEnhance = true;
    }
    vec4 srcCoordinate = vec4(textureCoordinate, 0., 1.);
    srcCoordinate = uMVPMatrix * srcCoordinate;
    if (srcCoordinate.x < 0.0 || srcCoordinate.x > 1.0 || srcCoordinate.y < 0.0 || srcCoordinate.y > 1.0) {
        gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
        return;
    }
    highp vec4 enhanceColor = texture2D(inputImageTexture2, srcCoordinate.xy);
    if (isEnhance) {
        gl_FragColor = enhanceColor;
    } else {
        highp vec4 srcColor = texture2D(inputImageTexture, srcCoordinate.xy);
        gl_FragColor = vec4(srcColor.rgb, enhanceColor.a);
    }

}