
precision highp float;
varying highp vec2 textureCoordinate;
varying highp vec2 textureCoordinate2;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;

uniform float blendWeight;

vec4 unpremultiply(vec4 s) {
    return vec4(s.rgb/max(s.a, 0.00001), s.a);
}

vec4 premultiply(vec4 s) {
    return vec4(s.rgb * s.a, s.a);
}

vec4 normalBlend(vec4 Cb, vec4 Cs) {
    vec4 dst = premultiply(Cb);
    vec4 src = premultiply(Cs);
    return unpremultiply(src  +dst * (1.0 - src.a));
}

vec3 saturate(vec3 v) {
    return clamp(v, 0.0, 1.0);
}

vec4 blendBaseAlpha(vec4 Cb, vec4 Cs, vec4 B) {
    vec4 Cr = vec4((1.0 - Cb.a) * Cs.rgb + Cb.a * saturate(B.rgb), Cs.a);
    return normalBlend(Cb, Cr);
}

//  softLight
float softLightBlendSingleChannelD(float b) {
    return b <= 0.25? (((16.0 * b - 12.0) * b + 4.0) * b): sqrt(b);
}

float softLightBlendSingleChannel(float b, float s, float weight) {
    return s < 0.5? (b - weight * (1.0 - 2.0 * s) * b * (1.0 - b)) : (b + weight * (2.0 * s - 1.0) * (softLightBlendSingleChannelD(b) - b));
}

vec4 softLightBlend(vec4 Cb, vec4 Cs, float weight) {
    vec4 B = vec4(softLightBlendSingleChannel(Cb.r, Cs.r, weight), softLightBlendSingleChannel(Cb.g, Cs.r, weight), softLightBlendSingleChannel(Cb.b, Cs.r, weight), Cb.a);
    return B;
}
void main()
{
    highp vec4 baseColor = texture2D(inputImageTexture, textureCoordinate);
    highp vec4 garyColor = texture2D(inputImageTexture2, textureCoordinate);

    // 这里做一次转换因为单通道rgb的数据r 和 a 通过做了互换
    // Bitmap grayBitmap = Bitmap.createBitmap(bitmap.getWidth(), bitmap.getHeight(), Bitmap.Config.ALPHA_8);
    vec4 colorGray = vec4(garyColor);
    colorGray.a = garyColor.r;
    colorGray.r = garyColor.a;

    float realBlendWeight = blendWeight;
    if (colorGray.a < 127./255.) {
        realBlendWeight = 0.;
    }

    // 柔光叠加效果
    vec4 finalColor  = softLightBlend(baseColor, colorGray, realBlendWeight);

    // 确保各通道不会变为负值
    finalColor.rgb = clamp(finalColor.rgb, 0.0, 1.0);
    finalColor.a = baseColor.a;

    // 输出最终颜色
    gl_FragColor = finalColor;
}