
precision highp float;
varying highp vec2 textureCoordinate;
varying highp vec2 textureCoordinate2;
varying highp vec2 textureCoordinate3;
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;

uniform float state;
uniform vec2 center;
uniform float radius;

uniform float inputWidth;
uniform float inputHeight;

vec4 unpremultiply(vec4 s) {
    return vec4(s.rgb / max(s.a, 0.00001), s.a);
}

vec3 rgb2xyz(vec3 c) {
    vec3 tmp;
    tmp.x = (c.r > 0.04045) ? pow((c.r + 0.055) / 1.055, 2.4) : c.r / 12.92;
    tmp.y = (c.g > 0.04045) ? pow((c.g + 0.055) / 1.055, 2.4) : c.g / 12.92;
    tmp.z = (c.b > 0.04045) ? pow((c.b + 0.055) / 1.055, 2.4) : c.b / 12.92;
    return 100.0 * tmp * mat3(0.4124, 0.3576, 0.1805, 0.2126, 0.7152, 0.0722, 0.0193, 0.1192, 0.9505);
}

vec3 xyz2lab(vec3 c) {
    vec3 n = c / vec3(95.047, 100.0, 108.883);
    vec3 v;
    v.x = (n.x > 0.008856) ? pow(n.x, 1.0 / 3.0) : (7.787 * n.x) + (16.0 / 116.0);
    v.y = (n.y > 0.008856) ? pow(n.y, 1.0 / 3.0) : (7.787 * n.y) + (16.0 / 116.0);
    v.z = (n.z > 0.008856) ? pow(n.z, 1.0 / 3.0) : (7.787 * n.z) + (16.0 / 116.0);
    return vec3((116.0 * v.y) - 16.0, 500.0 * (v.x - v.y), 200.0 * (v.y - v.z));
}

vec3 rgb2lab(vec3 c) {
    return xyz2lab(rgb2xyz(c));
}

float calculateColorSimilarity(vec3 rgb1, vec3 rgb2) {
    vec3 lab1 = rgb2lab(rgb1);
    vec3 lab2 = rgb2lab(rgb2);
    float distance = length(lab1 - lab2);
    return 1.0 - clamp(distance / 100.0, 0.0, 1.0);
}

void main() {
    // Calculate the aspect ratio
    float aspectRatio = inputWidth / inputHeight;

    vec4 inputColor = texture2D(inputImageTexture, textureCoordinate);
    vec4 effectColor = texture2D(inputImageTexture2, textureCoordinate);
    if (inputColor.a == 0.0) {
        gl_FragColor = vec4(0.0);
        return;
    }
    vec4 blendColor = effectColor;
    vec4 highlightColor = texture2D(inputImageTexture3, textureCoordinate);
    vec2 adjustedCoord = vec2(textureCoordinate.x, center.y + (center.y - textureCoordinate.y) / aspectRatio);
    float distance = length(adjustedCoord - center);
    float alpha = clamp(distance / radius, 0.0, 1.0);
    alpha = 1.0 - alpha;
    bool editing = state == 1.0;
    if (distance > radius) {
        blendColor = inputColor;
    } else if (editing) {
        // difference
        vec4 centerColor = texture2D(inputImageTexture, center);
        float difference = calculateColorSimilarity(inputColor.rgb, centerColor.rgb);
        // mix the input color with the highlight color
        blendColor.rgb = mix(inputColor.rgb, highlightColor.rgb, difference);
        blendColor = mix(inputColor, blendColor, alpha);
    } else {
        // difference
        vec4 centerColor = texture2D(inputImageTexture, center);
        float difference = calculateColorSimilarity(effectColor.rgb, centerColor.rgb);
        // mix the input color with the blend color
        blendColor.rgb = mix(inputColor.rgb, blendColor.rgb, difference);
        blendColor = mix(inputColor, blendColor, alpha);
    }

    gl_FragColor = vec4(blendColor.rgb, inputColor.a);
}