precision highp float;

varying float uProgress;
varying float uDistance;

uniform vec2 uResolution;

uniform float uStartWidth;
uniform float uEndWidth;

uniform float uStartAlpha;
uniform float uEndAlpha;

uniform float uThickness;
uniform float uDiffusion;

uniform vec4 uDiffuseColor;
uniform vec4 uShineColor;
uniform vec4 lineColors[10];
uniform float lineColorsProgress[10];
uniform int lineColorsCount;

float funcS(float p) {
    return smoothstep(0.0, 2.0, p) * 0.833 + 0.975;
}

float funcE(float p) {
    return 1.0 - 0.667 / exp(1.0) + 0.667 / exp(p * 0.5);
}

float sdBezier(vec2 pos, vec2 A, vec2 B, vec2 C){
    vec2 a = B - A;
    vec2 b = A - 2.0*B + C;
    vec2 c = a * 2.0;
    vec2 d = A - pos;

    float kk = 1.0 / dot(b,b);
    float kx = kk * dot(a,b);
    float ky = kk * (2.0*dot(a,a)+dot(d,b)) / 3.0;
    float kz = kk * dot(d,a);

    float res = 0.0;

    float p = ky - kx*kx;
    float p3 = p*p*p;
    float q = kx*(2.0*kx*kx - 3.0*ky) + kz;
    float h = q*q + 4.0*p3;

    if(h >= 0.0){
        h = sqrt(h);
        vec2 x = (vec2(h, -h) - q) / 2.0;
        vec2 uv = sign(x)*pow(abs(x), vec2(1.0/3.0));
        float t = uv.x + uv.y - kx;
        t = clamp( t, 0.0, 1.0 );

        // 1 root
        vec2 qos = d + (c + b*t)*t;
        res = length(qos);
    }else{
        float z = sqrt(-p);
        float v = acos( q/(p*z*2.0) ) / 3.0;
        float m = cos(v);
        float n = sin(v)*1.732050808;
        vec3 t = vec3(m + m, -n - m, n - m) * z - kx;
        t = clamp( t, 0.0, 1.0 );

        // 3 roots
        vec2 qos = d + (c + b*t.x)*t.x;
        float dis = dot(qos,qos);

        res = dis;

        qos = d + (c + b*t.y)*t.y;
        dis = dot(qos,qos);
        res = min(res,dis);

        qos = d + (c + b*t.z)*t.z;
        dis = dot(qos,qos);
        res = min(res,dis);

        res = sqrt( res );
    }

    return res;
}

float getGlow(float dist, float radius, float intensity){
    return pow(radius/dist, intensity);
}

vec4 getColor(float p) {
    for(int i = 0; i < lineColorsCount; i++) {
       vec4 lineCol = lineColors[i];
       float progress = lineColorsProgress[i];
       if (progress >= p) {
           if (i == 0) {
               return lineCol;
           } else {
               float preProgress = lineColorsProgress[i - 1];
               vec4 preLineCol = lineColors[i - 1];
               if (preProgress <= p && progress >= preProgress) {
                   float np = (p - preProgress) / (progress - preProgress);
                   return mix(preLineCol, lineCol, np);
               }
           }
       }
   }

    vec4 lineCol = lineColors[lineColorsCount - 1];
    return lineCol;
}

void main() {
    float progress = uProgress;
    float distance = abs(uDistance);

    float width = uStartWidth - progress * (uStartWidth - uEndWidth);
    if (distance > width) {
        discard;
    }
    float alpha = uStartAlpha - progress * (uStartAlpha - uEndAlpha);
    float dis = distance / width;

    float p = 1.0 - abs(dis) * 2.0;
    p = 1.0 - p*p;

    //vec4 color = mix(uShineColor, uDiffuseColor, p);
    //float a = mix(uShineColor.a, uDiffuseColor.a, p*p);
    //vec4 color = mix(uDiffuseColor, uShineColor, dis);
    //color.a *= step(dis, ratio) * (1.0 - step(thickness, 0.0));
    //color.a *= alpha;

    gl_FragColor = getColor(p);//lineColors[0];//vec4(color.rgb * a, a);
}
