
precision highp float;

varying vec2 textureCoordinate;
varying vec2 textureCoordinate2;
varying vec2 textureCoordinate3;
varying vec2 textureCoordinate4;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;
uniform sampler2D inputImageTexture4;

const float MASK_ALPHA_NORMAL_FACTOR = 0.6; // alpha = 0.6

uniform mat4 mStickerMatrix;
uniform float inputColor[4];
uniform float paintType;
uniform float isActive;
uniform float intensity;
uniform float alpha;
uniform float operationAlpha;

void main() {
    vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);
    if (textureColor.a == 0.) {
        gl_FragColor = vec4(0);
        return;
    }

    vec4 textureColor2 = texture2D(inputImageTexture2, textureCoordinate);
    vec4 doodleTexture = texture2D(inputImageTexture3, textureCoordinate3);
    vec4 textureColor4 = texture2D(inputImageTexture4, textureCoordinate);

    vec4 result = textureColor2;

    if (paintType == 0.) { // Normal
        float alpha = doodleTexture.a;
        if (isActive <= 0.) {
            if (doodleTexture.a > 0. && operationAlpha > 0.) {
                vec4 mask = vec4(inputColor[0], inputColor[1], inputColor[2], 1.);
                mask = mask * alpha * MASK_ALPHA_NORMAL_FACTOR;
                vec4 temp = mask * textureColor4.a;
                result = textureColor2 * (1. - temp.a) + temp;
            }
        } else {
            if (doodleTexture.a > 0. && operationAlpha > 0.) {
                vec3 temp1 = textureColor.rgb * intensity + textureColor2.rgb * (1. - intensity);
                vec3 temp2 = temp1 * alpha + textureColor2.rgb * (1. - alpha);
                vec3 temp3 = temp2 * textureColor4.a + textureColor2.rgb * (1. - textureColor4.a);
                result = vec4(temp3, textureColor2.a);
            }
        }
    } else if (paintType == 1.) { // Realtime
        if (doodleTexture.a > 0.) {
            float alpha = doodleTexture.a;
            vec3 temp1 = textureColor.rgb * intensity + textureColor2.rgb * (1. - intensity);
            vec3 temp2 = temp1 * alpha + textureColor2.rgb * (1. - alpha);
            vec3 temp3 = temp2 * textureColor4.a + textureColor2.rgb * (1. - textureColor4.a);
            result = vec4(temp3, textureColor2.a);
        }
    } else if (paintType == 2.) { // Contrast
        if (isActive <= 0.) {
            vec4 mask = vec4(inputColor[0], inputColor[1], inputColor[2], 1.);
            mask = mask * doodleTexture.a * (1. - alpha);
            vec4 temp = mask * textureColor4.a;
            result = textureColor2 * (1. - temp.a) + temp;
        }
    } else { // Eraser
        if (doodleTexture.a > 0.) {
            vec3 temp1 = textureColor4.rgb;
            vec3 temp2 = temp1 * doodleTexture.a + textureColor2.rgb * (1. - doodleTexture.a);
            vec3 temp3 = temp2 * textureColor4.a + textureColor2.rgb * (1. - textureColor4.a);
            result = vec4(temp3, textureColor4.a);
        }
    }

    gl_FragColor = result;
}