precision highp float;
varying highp vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;

uniform mat4 mBlendMatrix;
uniform vec4 trackColor;
uniform int paintType;

void main() {
    vec4 maskColor = texture2D(inputImageTexture2, textureCoordinate);
    vec4 srcColor = texture2D(inputImageTexture, textureCoordinate);
    vec4 baseColor = texture2D(inputImageTexture3, textureCoordinate);
    if (trackColor.a == 0.){
        maskColor = vec4(0.0, 0.0, 0.0, 0.0);
    }
    if (paintType == 0){
        if (trackColor.a == 0.){
            maskColor = vec4(0.0, 0.0, 0.0, 0.0);
        }
        vec4 dest=trackColor*maskColor.a*0.6;
        vec4 temp=dest*srcColor.a;
        gl_FragColor = srcColor*(1.-temp.a)+temp;
    } else {
        gl_FragColor = mix(srcColor, baseColor, maskColor.a);
    }
}