precision highp float;
varying highp vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;
uniform int isFlip;
uniform vec2 offset;
uniform vec2 flipPoint;// 指定的翻转点，范围为 [0, 1]
uniform float rotationAngle; // 旋转角度（弧度）

void main() {
    vec4 doodleColor = texture2D(inputImageTexture2, textureCoordinate);
    if (doodleColor.a > 0.1) {
        float patchCoordX = textureCoordinate.x + offset.x;
        float patchCoordY = textureCoordinate.y + offset.y;

        if (isFlip == 1) {
            // 计算翻转后的纹理坐标
            patchCoordX = 2.0 * flipPoint.x - patchCoordX;
        }

        // 绕 flipPoint 旋转
        float sinAngle = sin(rotationAngle);
        float cosAngle = cos(rotationAngle);
        float rotatedX = (patchCoordX - flipPoint.x) * cosAngle - (patchCoordY - flipPoint.y) * sinAngle + flipPoint.x;
        float rotatedY = (patchCoordX - flipPoint.x) * sinAngle + (patchCoordY - flipPoint.y) * cosAngle + flipPoint.y;

        // 更新 patchCoord
        patchCoordX = rotatedX;
        patchCoordY = rotatedY;

        vec2 patchCoord = vec2(patchCoordX, patchCoordY);

        if (patchCoord.x >= 0.0 && patchCoord.x <= 1.0 &&
        patchCoord.y >= 0.0 && patchCoord.y <= 1.0) {
            vec4 sampledColor = texture2D(inputImageTexture, patchCoord);
            gl_FragColor = sampledColor;
        } else {
            gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
        }
    } else {
        gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
    }
}