
precision highp float;
varying highp vec2 textureCoordinate;
varying highp vec2 textureCoordinate2;
varying highp vec2 textureCoordinate3;
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;

const float MASK_ALPHA_FACTOR = 0.6;// alpha = 0.6

uniform int frontBackType;
uniform int playingAnimation;
uniform float alphaValue;

void main() {
    vec4 inputColor = texture2D(inputImageTexture, textureCoordinate);
    vec4 blendColor = texture2D(inputImageTexture2, textureCoordinate);
    vec4 maskColor = texture2D(inputImageTexture3, textureCoordinate);

    blendColor.rgb = mix(inputColor.rgb, blendColor.rgb, MASK_ALPHA_FACTOR);

    if (frontBackType == 0) {
        gl_FragColor= mix(blendColor, inputColor, maskColor.a);
    } else {
        gl_FragColor= mix(inputColor, blendColor, maskColor.a);
    }
}