
precision highp float;
varying highp vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;

uniform mat4 mBlendMatrix;
uniform vec4 trackColor;
uniform int paintType;
vec4 unpremultiply(vec4 s) {
    return vec4(s.rgb/max(s.a, 0.00001), s.a);
}

vec4 premultiply(vec4 s) {
    return vec4(s.rgb * s.a, s.a);
}
vec4 normalBlend(vec4 Cb, vec4 Cs) {
    vec4 dst = premultiply(Cb);
    vec4 src = premultiply(Cs);
    return src  +dst * (1.0 - src.a);
}

void main() {
    vec4 maskColor = texture2D(inputImageTexture2, textureCoordinate);
    vec4 srcColor = texture2D(inputImageTexture, textureCoordinate);
    vec4 baseColor = texture2D(inputImageTexture3, textureCoordinate);
    if (paintType == 0){
        vec4 dest=trackColor*maskColor.a*0.6;
        gl_FragColor =dest   +srcColor * (1.0 - dest.a);
        //        normalBlend(srcColor, dest);

    } else {
        gl_FragColor = mix(srcColor, baseColor, maskColor.a);
    }
}