
precision highp float;
varying highp vec2 textureCoordinate;
varying highp vec2 textureCoordinate2;// TODO: This is not used
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;

vec4 unpremultiply(vec4 s) {
    return vec4(s.rgb/max(s.a, 0.00001), s.a);
}

vec4 premultiply(vec4 s) {
    return vec4(s.rgb * s.a, s.a);
}

vec4 normalBlend(vec4 Cb, vec4 Cs) {
    vec4 dst = premultiply(Cb);
    vec4 src = premultiply(Cs);
    return unpremultiply(src + dst * (1. - src.a));
}

vec3 saturate(vec3 v) {
    return clamp(v, 0., 1.);
}

vec4 blendBaseAlpha(vec4 Cb, vec4 Cs, vec4 B) {
    vec4 Cr = vec4((1. - Cb.a) * Cs.rgb + Cb.a * saturate(B.rgb), Cs.a);
    return normalBlend(Cb, Cr);
}

float overlayBlendSingleChannel(float b, float s) {
    if (b<0.5) {
        return 2.*b*s;
    } else {
        return 1.-2.*(1.-b)*(1.-s);
    }
}

vec4 blendOverlay(vec4 Cb, vec4 Cs) {
    vec4 B = vec4(overlayBlendSingleChannel(Cb.r, Cs.r), overlayBlendSingleChannel(Cb.g, Cs.g), overlayBlendSingleChannel(Cb.b, Cs.b), Cs.a);
    return blendBaseAlpha(Cb, Cs, B);
}

void main()
{
    highp vec4 baseColor = texture2D(inputImageTexture, textureCoordinate);
    highp vec4 blendColor = texture2D(inputImageTexture2, textureCoordinate);
    if (baseColor.a <= 0.) {
        gl_FragColor = blendColor;
    } else {
        highp vec4 resultColor = blendOverlay(baseColor, blendColor);
        gl_FragColor = resultColor;
    }
}