
precision highp float;
varying highp vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;// lookup texture

uniform float contrast;

float rand(vec2 coordinate) {
    float a = 12.9898;
    float b = 78.233;
    float c = 43758.5453;

    float dt = dot(coordinate.xy, vec2(a, b));
    float sn = mod(dt, 3.14159);
    return fract((sin(sn) * c));
}

void main()
{
    vec4 baseColor = texture2D(inputImageTexture, textureCoordinate);
    vec4 blendColor = texture2D(inputImageTexture2, textureCoordinate);
    float noise = rand(textureCoordinate);
    noise = noise * contrast - contrast / 2.;
    gl_FragColor = vec4(blendColor.rgb + noise, baseColor.a);
}