precision highp float;

varying vec2 textureCoordinate;
varying vec2 textureCoordinate2;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;

vec4 unpremultiply(vec4 s) {
    return vec4(s.rgb/max(s.a, 0.00001), s.a);
}

vec4 premultiply(vec4 s) {
    return vec4(s.rgb * s.a, s.a);
}

vec4 normalBlend(vec4 Cb, vec4 Cs) {
    vec4 dst = premultiply(Cb);
    vec4 src = premultiply(Cs);
    return unpremultiply(src + dst * (1.0 - src.a));
}

vec4 blendBaseAlpha(vec4 Cb, vec4 Cs, vec4 B) {
    vec4 Cr = vec4((1.0 - Cb.a) * Cs.rgb + Cb.a * B.rgb, Cs.a);
    return normalBlend(Cb, Cr);
}

vec4 addBlend(vec4 Cb, vec4 Cs) {
    vec4 B = min(Cb + Cs, 1.0);
    return blendBaseAlpha(Cb, Cs, B);
}

void main() {
    vec4 overlay = texture2D(inputImageTexture, textureCoordinate);
    vec4 mask = texture2D(inputImageTexture2, textureCoordinate2);

    vec4 blendedColor = addBlend(overlay, mask);
    gl_FragColor = blendedColor;
}