
precision highp float;
varying highp vec2 textureCoordinate;
varying highp vec2 textureCoordinate2;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;

uniform float strength;
uniform float inputColor[4];

vec4 unpremultiply(vec4 s) {
    return vec4(s.rgb/max(s.a, 0.00001), s.a);
}

vec4 premultiply(vec4 s) {
    return vec4(s.rgb * s.a, s.a);
}

vec4 normalBlend(vec4 Cb, vec4 Cs) {
    vec4 dst = premultiply(Cb);
    vec4 src = premultiply(Cs);
    return unpremultiply(src  +dst * (1.0 - src.a));
}

vec3 saturate(vec3 v) {
    return clamp(v, 0.0, 1.0);
}

vec4 blendBaseAlpha(vec4 Cb, vec4 Cs, vec4 B) {
    vec4 Cr = vec4((1.0 - Cb.a) * Cs.rgb + Cb.a * saturate(B.rgb), Cs.a);
    return normalBlend(Cb, Cr);
}

highp float lum(highp vec4 C) {
    return 0.299 * C.r + 0.587 * C.g + 0.114 * C.b;
}
vec4 clipColor(vec4 C) {
    float l = lum(C);
    float  n = min(C.r, min(C.g, C.b));
    float x = max(C.r, max(C.g, C.b));
    if (n < 0.0) {
        return vec4((l + ((C.rgb - l) * l) / (l - n)), C.a);
    }
    if (x > 1.) {
        return vec4(l + (((C.rgb - l) * (1. - l)) / (x - l)), C.a);
    }
    return C;
}

vec4 setLum(vec4 C, float l) {
    float d = l - lum(C);
    return clipColor(vec4(C.rgb + d, C.a));
}
vec4 saturate(vec4 x) {
    return clamp(x, 0., 1.);
}
vec4 multiplyBlend(vec4 Cb, vec4 Cs) {
    vec4 B = saturate(vec4(Cb.rgb * Cs.rgb, Cs.a));
    return blendBaseAlpha(Cb, Cs, B);
}

vec4 multiplyBlend(vec4 Cb, vec4 Cs, float opacity) {
    return (multiplyBlend(Cb, Cs) * opacity + Cb * (1.0 - opacity));
}

vec4 getBandColor(vec4 belowRGB, vec4 aboveRGB, float lowerEdge, float lowestEdge, float higherEdge, float highestEdge) {
    float lumValue = lum(belowRGB);
    vec4 result = vec4(0., 0., 0., 1.0);
    if (lumValue < lowerEdge && lowerEdge >= lowestEdge) {
        vec4 backColor = multiplyBlend(aboveRGB* belowRGB.a, belowRGB);
        result = mix(backColor, belowRGB, (lumValue - lowerEdge) / (lowestEdge - lowerEdge));
    }
    if (lumValue <= higherEdge && lumValue >= lowerEdge) {
        result = multiplyBlend(aboveRGB* belowRGB.a, belowRGB);
    }
    if (lumValue > higherEdge && lumValue <= highestEdge) {
        vec4 backColor = multiplyBlend(aboveRGB* belowRGB.a, belowRGB);
        result = mix(backColor, belowRGB, (lumValue - higherEdge) / (highestEdge - higherEdge));
    }
    return result;
}

vec3 screenMode(vec3 first, vec3 second, float ratio) {
    return vec3(1.) - (vec3(1.) - first) * (vec3(1.) - second * ratio);
}

void main()
{
    vec4 faceColor = texture2D(inputImageTexture, textureCoordinate);
    // ScreenBlendColor
    vec4 maskColor = texture2D(inputImageTexture2, textureCoordinate2);
    vec4 inputColor = vec4(inputColor[0], inputColor[1], inputColor[2], 1.);
    
    vec3 firstStep = screenMode(faceColor.rgb, maskColor.rgb, 0.6);
    vec4 secondStep = getBandColor(vec4(firstStep, faceColor.a), inputColor, 0., 0., 140./255., 255./255.);
    vec3 mixedColor = mix(faceColor.rgb, secondStep.rgb, maskColor.a * strength);

    gl_FragColor = vec4(mixedColor, faceColor.a);
}