precision highp float;
varying highp vec2 textureCoordinate;
varying highp vec2 textureCoordinate2;
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
//uniform float intensity;

vec4 unpremultiply(vec4 s) {
    return vec4(s.rgb/max(s.a, 0.00001), s.a);
}

vec4 premultiply(vec4 s) {
    return vec4(s.rgb * s.a, s.a);
}

vec4 normalBlend(vec4 Cb, vec4 Cs) {
    vec4 dst = premultiply(Cb);
    vec4 src = premultiply(Cs);
    return unpremultiply(src + dst * (1.0 - src.a));
}

vec4 normalBlendNoPremultiply(vec4 Cb, vec4 Cs) {
    vec4 dst = (Cb);
    vec4 src = (Cs);
    return unpremultiply(src + dst * (1.0 - src.a));
}

vec3 saturate(vec3 rgb) {
    return clamp(rgb, vec3(0.0), vec3(1.0));
}

vec4 saturate2(lowp vec4 v) {
    return clamp(v, 0.0, 1.0);
}

vec4 blendBaseAlpha(vec4 Cb, vec4 Cs, vec4 B) {
    vec4 Cr = vec4((1.0 - Cb.a) * Cs.rgb + Cb.a * saturate(B.rgb), Cs.a);
    return normalBlend(Cb, Cr);
}

vec4 linearLightBlend(vec4 Cb, vec4 Cs) {
    vec4 B  = Cb + 2.0 * Cs - 1.0;
    return blendBaseAlpha(Cb, Cs, B);
}

vec4 overlayBlend(vec4 base, vec4 blend) {
    if (base.a <= 0.0) {
        return base;
    }
    if (blend.a <= 0.0) {
        return base;
    }
    vec4 result;
    result.a = 1.0;
    bvec3 isLessOrEqual = lessThanEqual(base.rgb, vec3(0.5));
    if (all(isLessOrEqual)){
        result.rgb = 2.0 * base.rgb * blend.rgb;
    } else {
        result.rgb = 1.0 - 2.0 * (1.0 - base.rgb) * (1.0 - blend.rgb);
    }
    return result;
}


void main()
{
    vec4 hairPartColor = texture2D(inputImageTexture, textureCoordinate);
    vec4 maskColor = texture2D(inputImageTexture2, textureCoordinate2);
    if (hairPartColor.a <=0.0){
        gl_FragColor =vec4(0., 0., 0., 0.);
    } else {
        vec4 remappedMaskColor = vec4(maskColor.rgb * 2.0 - 1.0,maskColor.a);
//        vec4 blendedColor = linearLightBlend(hairPartColor, maskColor);
        vec4 blendedColor = hairPartColor + remappedMaskColor;
        gl_FragColor = mix(hairPartColor, blendedColor, hairPartColor.a);
    }
}