precision highp float;
varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;

uniform float intensity;
//uniform float threshold = 0.05;

void main() {
    vec4 baseColor = texture2D(inputImageTexture, textureCoordinate);
    vec4 gaussColor = texture2D(inputImageTexture2, textureCoordinate);

    if (baseColor.a <= 0.) {
        gl_FragColor = baseColor;
    } else {
        vec3 sharpenColor = vec3(baseColor.rgb - gaussColor.rgb);
        sharpenColor = (sharpenColor + 1.0)/2.0;
        gl_FragColor = vec4(sharpenColor, baseColor.a);
    }
}