
precision highp float;
varying highp vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;

uniform float edgeWidth;
uniform vec2 inputSize;

bool edgeDetection(vec2 coordinate, float width) {
    float left = coordinate.x - width / 2.;
    float top = coordinate.y + width / 2.;
    float right = coordinate.x + width / 2.;
    float bottom = coordinate.y - width / 2.;

    vec2 leftTop = vec2(left, top);
    vec2 rightTop = vec2(right, top);
    vec2 leftBottom = vec2(left, bottom);
    vec2 rightBottom = vec2(right, bottom);

    bool leftTopEdge = texture2D(inputImageTexture2, leftTop).a > 0.0;
    bool rightTopEdge = texture2D(inputImageTexture2, rightTop).a > 0.0;
    bool leftBottomEdge = texture2D(inputImageTexture2, leftBottom).a > 0.0;
    bool rightBottomEdge = texture2D(inputImageTexture2, rightBottom).a > 0.0;

    bool isEdge = false;
    if (leftTopEdge && rightTopEdge && leftBottomEdge && rightBottomEdge) {
        isEdge = false;
    } else if (leftTopEdge || rightTopEdge || leftBottomEdge || rightBottomEdge) {
        isEdge = true;
    }
    return isEdge;
}

void main()
{
    vec4 baseColor = texture2D(inputImageTexture, textureCoordinate);
    vec4 maskColor = texture2D(inputImageTexture2, textureCoordinate);
    if (baseColor.a <= 0.0) {
        gl_FragColor = baseColor;
    } else {
        if (edgeDetection(textureCoordinate, edgeWidth / inputSize.x)) {
            gl_FragColor = baseColor;
        } else {
            gl_FragColor = vec4(0., 0., 0., 0.);
        }
    }
}