
precision highp float;
varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;// 原始纹理
uniform sampler2D inputImageTexture2;// 特效纹理
uniform mat4 mBlendMatrix;
vec4 unpremultiply(vec4 s) {
    return vec4(s.rgb/max(s.a, 0.00001), s.a);
}

vec4 premultiply(vec4 s) {
    return vec4(s.rgb * s.a, s.a);
}

vec4 normalBlend(vec4 Cb, vec4 Cs) {
    vec4 dst = premultiply(Cb);
    vec4 src = premultiply(Cs);
    return unpremultiply(src  +dst * (1.0 - src.a));
}

vec3 saturate(vec3 v) {
    return clamp(v, 0.0, 1.0);
}

vec4 blendBaseAlpha(vec4 Cb, vec4 Cs, vec4 B) {
    vec4 Cr = vec4((1.0 - Cb.a) * Cs.rgb + Cb.a * saturate(B.rgb), Cs.a);
    return normalBlend(Cb, Cr);
}

vec4 screenBlend(vec4 Cb, vec4 Cs) {
    vec4 White = vec4(1.0);
    vec4 B = White - ((White - Cs) * (White - Cb));
    return blendBaseAlpha(Cb, Cs, B);
}

void main()
{
    vec4 srcColor=texture2D(inputImageTexture, textureCoordinate);
    vec4 mEffectSrcColor = vec4(.0);
    vec4 bgCoordinate=vec4(textureCoordinate, 0., 1.);
    bgCoordinate= mBlendMatrix * bgCoordinate;
    if (bgCoordinate.x>=0.&&bgCoordinate.x<=1.&&bgCoordinate.y>=0.&&bgCoordinate.y<=1.){
        mEffectSrcColor=texture2D(inputImageTexture2, bgCoordinate.xy);
    }
    gl_FragColor = screenBlend(srcColor, mEffectSrcColor);
}