precision highp float;
varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;
uniform int style;
uniform float offsetX;
uniform float offsetY;

vec4 colorSplit(vec2 uv) {
    vec4 color1 = texture2D(inputImageTexture, uv - vec2(offsetX / 2.0, offsetY / 2.0));
    vec4 color2 = texture2D(inputImageTexture, uv + vec2(offsetX / 2.0, offsetY / 2.0));
    vec4 color3 = texture2D(inputImageTexture, uv);
    vec3 color;
    if (style == 0) {
        color = vec3(color1.rg, color2.b);
    } else if (style == 1) {
        color = vec3(color1.r, color2.gb);
    } else if (style == 2) {
        color = vec3(color1.r, color2.g, color1.b);
    } else {
        color = vec3(color2.r, color3.g, color1.b);
    }
    color = clamp(color, 0.0, 1.0);
    return vec4(color.r, color.g, color.b, 1.0);
}

void main() {
    gl_FragColor = colorSplit(textureCoordinate);
}
