
precision highp float;
varying highp vec2 textureCoordinate;
varying highp vec2 textureCoordinate2;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform int premultiplied;

vec4 unpremultiply(vec4 s) {
    return vec4(s.rgb/max(s.a, 0.00001), s.a);
}

vec4 premultiply(vec4 s) {
    return vec4(s.rgb * s.a, s.a);
}

vec4 normalBlend(vec4 Cb, vec4 Cs) {
    vec4 dst = premultiply(Cb);
    vec4 src = premultiply(Cs);
    return unpremultiply(src  +dst * (1.0 - src.a));
}

vec3 saturate(vec3 v) {
    return clamp(v, 0.0, 1.0);
}

vec4 blendBaseAlpha(vec4 Cb, vec4 Cs, vec4 B) {
    vec4 Cr = vec4((1.0 - Cb.a) * Cs.rgb + Cb.a * saturate(B.rgb), Cs.a);
    return normalBlend(Cb, Cr);
}

float lum(vec4 C) {
    return 0.299 * C.r + 0.587 * C.g + 0.114 * C.b;
}
vec4 clipColor(vec4 C) {
    float l = lum(C);
    float  n = min(C.r, min(C.g, C.b));
    float x = max(C.r, max(C.g, C.b));
    if (n < 0.0) {
        return vec4((l + ((C.rgb - l) * l) / (l - n)), C.a);
    }
    if (x > 1.) {
        return vec4(l + (((C.rgb - l) * (1. - l)) / (x - l)), C.a);
    }
    return C;
}

vec4 setLum(vec4 C, float l) {
    float d = l - lum(C);
    return clipColor(vec4(C.rgb + d, C.a));
}

float colorDodgeBlendSingleChannel(float b, float f) {
    if (b == 0.0) {
        return 0.0;
    } else if (f == 1.0) {
        return 1.0;
    } else {
        return min(1.0, b / (1.0 - f));
    }
}

vec4 colorDodgeBlend(vec4 Cb, vec4 Cs) {
    vec4 B = vec4(colorDodgeBlendSingleChannel(Cb.r, Cs.r), colorDodgeBlendSingleChannel(Cb.g, Cs.g), colorDodgeBlendSingleChannel(Cb.b, Cs.b), Cs.a);
    return blendBaseAlpha(Cb, Cs, B);
}


void main()
{
    vec4 baseColor = texture2D(inputImageTexture, textureCoordinate);
    if (premultiplied == 1){
        vec4 blendColor = unpremultiply(texture2D(inputImageTexture2, textureCoordinate2));
        gl_FragColor = colorDodgeBlend(baseColor, blendColor);
    } else {
        vec4 blendColor = texture2D(inputImageTexture2, textureCoordinate2);
        gl_FragColor = colorDodgeBlend(baseColor, blendColor);
    }
}