
precision highp float;

varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;

uniform vec2 textureSize;
uniform vec2 firstCenter;
uniform vec2 secondCenter;
uniform float firstRadius;
uniform float secondRadius;
uniform float scale;

void main()
{
    vec2 position=textureCoordinate;
    vec2 realPosition=vec2(position.x*textureSize.x, position.y*textureSize.y);
    vec2 realFirstCenter=vec2(firstCenter.x*textureSize.x, firstCenter.y*textureSize.y);
    vec2 realSecondCenter=vec2(secondCenter.x*textureSize.x, secondCenter.y*textureSize.y);

    float realFirstRadius=firstRadius*textureSize.x;
    float realSecondRadius=secondRadius*textureSize.x;

    float firstDis=distance(realPosition, realFirstCenter);
    float secondDis=distance(realPosition, realSecondCenter);

    vec2 firstOffset=vec2(0.);
    if (firstDis<=realFirstRadius && firstDis != 0.) {
        float ratio=firstDis/realFirstRadius;
        float realScale = scale - (scale - 1.) * ratio;
        vec2 originalPosition = vec2(0.);
        originalPosition.x = (realPosition.x - realFirstCenter.x) / firstDis * (firstDis / realScale) + realFirstCenter.x;
        originalPosition.y = (realPosition.y - realFirstCenter.y) / firstDis * (firstDis / realScale) + realFirstCenter.y;
        firstOffset = originalPosition - realPosition;
    }
    vec2 secondOffset=vec2(0.);
    if (secondDis<=realSecondRadius && secondDis != 0.) {
        float ratio = secondDis / realSecondRadius;
        float realScale = scale - (scale - 1.) * ratio;
        vec2 originalPosition = vec2(0.);
        originalPosition.x = (realPosition.x - realSecondCenter.x) / secondDis * (secondDis / realScale) + realSecondCenter.x;
        originalPosition.y = (realPosition.y - realSecondCenter.y) / secondDis * (secondDis / realScale) + realSecondCenter.y;
        secondOffset = originalPosition - realPosition;
    }
    vec2 originalPosition = realPosition + (firstOffset + secondOffset);
    position.x = originalPosition.x / textureSize.x;
    position.y = originalPosition.y / textureSize.y;
    gl_FragColor=texture2D(inputImageTexture, position);
}