
precision highp float;
varying highp vec2 textureCoordinate;
varying highp vec2 textureCoordinate2;
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;

void main()
{
    highp vec4 blendColor = texture2D(inputImageTexture, textureCoordinate);
    highp vec4 finalColor = texture2D(inputImageTexture2, textureCoordinate);
    highp vec4 resultColor = blendColor + finalColor;

    // 确保各通道不会变为负值
    resultColor.rgb = clamp(resultColor.rgb, 0.0, 1.0);

    gl_FragColor = resultColor;
}