precision highp float;

varying highp vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform mat4 mBlendMatrix;
uniform vec4 drawRect;// 归一化坐标 [x,y,z,w]
uniform vec4 expandAnimationRect;// 归一化坐标 [x,y,z,w]

uniform vec2 inputSize;
uniform int needBackground;

vec4 getCheckerboardColor(vec2 coord, vec2 dimensions, vec4 drawRectNorm) {
    float cellSize = 30.0/(1080.0/dimensions.x);

    // 直接使用归一化坐标判断是否在绘制区域内
    if (coord.x < drawRectNorm.x || coord.x > drawRectNorm.z ||
    coord.y < drawRectNorm.y || coord.y > drawRectNorm.w) {
        return vec4(0.0, 0.0, 0.0, 0.0);// 区域外透明
    }

    // 计算在绘制区域内的相对位置 [0,1]
    vec2 localNormCoord = (coord - drawRectNorm.xy) / (drawRectNorm.zw - drawRectNorm.xy);

    // 转换为像素坐标（相对于绘制区域）
    vec2 localPixelCoord = localNormCoord * (drawRectNorm.zw - drawRectNorm.xy) * dimensions;

    // 使用固定像素大小划分格子
    int xIndex = int(floor(localPixelCoord.x / cellSize));
    int yIndex = int(floor(localPixelCoord.y / cellSize));

    if (mod(float(xIndex + yIndex), 2.0) == 0.0) {
        return vec4(0.4, 0.4, 0.4, 1.0);// 深灰
    } else {
        return vec4(0.6, 0.6, 0.6, 1.0);// 浅灰
    }
}

vec4 getForegroundTextureColor(vec2 texCoordToSample) {
    vec4 transformedCoordinate = vec4(texCoordToSample, 0.0, 1.0);
    transformedCoordinate = mBlendMatrix * transformedCoordinate;

    if (transformedCoordinate.x < 0.0 || transformedCoordinate.x > 1.0 ||
    transformedCoordinate.y < 0.0 || transformedCoordinate.y > 1.0) {
        return vec4(0.0, 0.0, 0.0, 0.0);// 完全透明
    }
    return texture2D(inputImageTexture, transformedCoordinate.xy);
}

// 更健壮的矩形校验
bool isValidRect(vec4 rect) {
    return (rect.z > rect.x + 0.001) && (rect.w > rect.y + 0.001);// 加入微小阈值
}
void main() {
    vec4 backgroundColor = getCheckerboardColor(textureCoordinate, inputSize, drawRect);
    vec4 foregroundColor = getForegroundTextureColor(textureCoordinate);

    if (needBackground == 1) {
        // 预计算混合结果
        float alpha = foregroundColor.a;
        vec3 mixedRGB = mix(backgroundColor.rgb, foregroundColor.rgb, alpha);
        vec4 blendedColor = vec4(mixedRGB, alpha + backgroundColor.a * (1.0 - alpha));

        if (isValidRect(expandAnimationRect)) {
            bool inAnimationArea = all(greaterThanEqual(textureCoordinate, expandAnimationRect.xy)) &&
            all(lessThanEqual(textureCoordinate, expandAnimationRect.zw));

            gl_FragColor = inAnimationArea ? blendedColor : backgroundColor;
        } else {
            // 无效矩形默认使用混合效果
            gl_FragColor = blendedColor;
        }
    } else {
        gl_FragColor = foregroundColor;
    }
}