
precision highp float;
varying highp vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;

uniform mat4 mBlendMatrix;
uniform int frontBackType;

void main() {
    vec4 coordinate = vec4(textureCoordinate, 0., 1.);
    coordinate = mBlendMatrix * coordinate;
    if (coordinate.x < 0. || coordinate.x > 1. || coordinate.y < 0. || coordinate.y > 1.) {
        gl_FragColor = texture2D(inputImageTexture, textureCoordinate);
        return;
    }
    mediump vec4 srcColor = texture2D(inputImageTexture, textureCoordinate);
    mediump vec4 maskColor = texture2D(inputImageTexture2, textureCoordinate);
    mediump vec4 adjustColor = texture2D(inputImageTexture3, textureCoordinate);
    float alpha = 1.;
    if (frontBackType == 1) {
        alpha = maskColor.a;
    } else if (frontBackType == 2) {
        alpha = 1. - maskColor.a;
    }
    gl_FragColor = mix(srcColor, adjustColor, alpha);
}