
precision highp float;
varying highp vec2 textureCoordinate;
varying highp vec2 textureCoordinate2;// TODO: This is not used
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;

float blendOverlayFloat(float base, float blend)
{
    if (base<0.5) {
        return 2.0*base*blend;
    }
    else {
        return 1.0-2.0*(1.0-base)*(1.0-blend);
    }
}

vec3 doBlendOverlay(vec3 base, vec3 blend)
{
    float blendR = blendOverlayFloat(base.r, blend.r);
    float blendG = blendOverlayFloat(base.g, blend.g);
    float blendB = blendOverlayFloat(base.b, blend.b);
    return vec3(blendR, blendG, blendB);
}

vec3 blendOverlay(vec3 base, vec3 blend, float opacity)
{
    return (doBlendOverlay(base, blend) * opacity + base * (1.0 - opacity));
}

void main()
{
    highp vec4 baseColor = texture2D(inputImageTexture, textureCoordinate);
    highp vec4 blendColor = texture2D(inputImageTexture2, textureCoordinate);
    if (baseColor.a <= 0.0) {
        gl_FragColor = baseColor;
    } else {
        highp vec3 resultColor = blendOverlay(baseColor.rgb, blendColor.rgb, 0.1);
        gl_FragColor = vec4(resultColor.rgb, baseColor.a);
    }
}