select
    Now_Playing_Queue.Type as Type,
    coalesce (stations.stationToken, Now_Playing_Queue.Pandora_Id) as Pandora_Id,
    coalesce(On_Demand_Tracks.Name, Albums.Name, On_Demand_Playlists.Name, stations.stationName, '') as Name,
    coalesce(On_Demand_Tracks.Artist_Name, Artists.Name, NULLIF(On_Demand_Playlists.Owner_Fullname, ''), On_Demand_Playlists.Owner_Webname, '') as Artist_Name,
    Albums.Icon_Url as Icon_Url,
    coalesce(On_Demand_Playlists.Artwork_Url_Path, stations.artUrl) as Artwork_Url_Path,
    On_Demand_Tracks.Duration as Duration,
    coalesce(Albums.Track_Count, On_Demand_Playlists.Total_Tracks, 0) as Track_Count,
    coalesce(Albums.Icon_Dominant_Color, stations.dominantColor, '') as Icon_Dominant_Color,
    coalesce(On_Demand_Tracks.Explicitness, Albums.Explicitness, '') as Explicitness,
    (NOT stations.isThumbprint AND NOT stations.isQuickMix AND stations.isAdvertiser) as Is_Hybrid_Station
from Now_Playing_Queue
    LEFT JOIN On_Demand_Playlists on Now_Playing_Queue.Pandora_Id =  On_Demand_Playlists.Pandora_Id
    LEFT JOIN On_Demand_Tracks on Now_Playing_Queue.Pandora_Id = On_Demand_Tracks.Pandora_Id
    LEFT JOIN stations on stations.Pandora_Id = Now_Playing_Queue.Pandora_Id
    LEFT JOIN Albums on (Now_Playing_Queue.Pandora_Id = Albums.Pandora_Id or On_Demand_Tracks.Album_Pandora_Id = Albums.Pandora_Id)
    LEFT JOIN Artists on Artists.Pandora_Id = Albums.Artist_Pandora_Id
order by Now_Playing_Queue.Position ASC