/*
    v_recents - Columns: RECENTS_PROJECTION
    This view represents a user collection and a single collected item can by of type Track, Album
    Playlist or Station. Due to complexity of this view's query the view definition is a single
    string constant containing both projections and table joins. See CREATE_COLLECTED_ITEMS_VIEW.
 */

CREATE VIEW V_Recents
AS
SELECT Recents.Pandora_Id,
	Recents.Type,
	Recents.Created_Date,
	Recents.Is_From_Collection,
	On_Demand_Tracks.NAME,
	IFNULL(Albums.Local_Icon_Url, Albums.Icon_Url) AS Icon_Url,
	Albums.Icon_Dominant_Color,
	Artists.NAME AS Artist_Name,
	0 AS isThumbprint,
	CAST(IFNULL((
				SELECT CASE WHEN Downloaded_Items.Pending_Download_Status != 0 THEN Downloaded_Items.Pending_Download_Status ELSE Downloaded_Items.Download_Status END
				FROM Downloaded_Items
				WHERE Downloaded_Items.Pandora_Id = On_Demand_Tracks.Pandora_Id
				), 0) AS TEXT) AS Download_Status
FROM Recents
INNER JOIN On_Demand_Tracks ON (Recents.Pandora_Id = On_Demand_Tracks.Pandora_Id)
INNER JOIN Albums ON (On_Demand_Tracks.Album_Pandora_Id = Albums.Pandora_Id)
INNER JOIN Artists ON (On_Demand_Tracks.Artist_Pandora_Id = Artists.Pandora_Id)

UNION

SELECT Recents.Pandora_Id,
	Recents.Type,
	Recents.Created_Date,
	Recents.Is_From_Collection,
	Albums.NAME,
	IFNULL(Albums.Local_Icon_Url, Albums.Icon_Url) AS Icon_Url,
	Albums.Icon_Dominant_Color,
	Artists.NAME AS Artist_Name,
	0 AS isThumbprint,
	CAST((
			SELECT CASE WHEN Downloaded_Items.Pending_Download_Status != 0 THEN Downloaded_Items.Pending_Download_Status ELSE Downloaded_Items.Download_Status END
			FROM Downloaded_Items
			WHERE Albums.Pandora_Id = Downloaded_Items.Pandora_Id
			) AS TEXT) AS Download_Status
FROM Recents
INNER JOIN Albums ON (Recents.Pandora_Id = Albums.Pandora_Id)
INNER JOIN Artists ON (Albums.Artist_Pandora_Id = Artists.Pandora_Id)

UNION

SELECT Recents.Pandora_Id,
	Recents.Type,
	Recents.Created_Date,
	Recents.Is_From_Collection,
	On_Demand_Playlists.NAME,
	IFNULL(On_Demand_Playlists.Local_Icon_Url, On_Demand_Playlists.Artwork_Url_Path) AS Icon_Url,
	'' AS Icon_Dominant_Color,
	NULL AS Artist_Name,
	0 AS isThumbprint,
	CAST((
			SELECT CASE WHEN Downloaded_Items.Pending_Download_Status != 0 THEN Downloaded_Items.Pending_Download_Status ELSE Downloaded_Items.Download_Status END
			FROM Downloaded_Items
			WHERE On_Demand_Playlists.Pandora_Id = Downloaded_Items.Pandora_Id
			) AS TEXT) AS Download_Status
FROM Recents
INNER JOIN On_Demand_Playlists ON (Recents.Pandora_Id = On_Demand_Playlists.Pandora_Id)

UNION

SELECT Recents.Pandora_Id,
	Recents.Type,
	Recents.Created_Date,
	Recents.Is_From_Collection,
	stations.stationName,
	IFNULL(stations.localArtUrl, stations.artUrl) AS Icon_Url,
	'' AS Icon_Dominant_Color,
	NULL AS Artist_Name,
	stations.isThumbprint,
	CAST(IFNULL(stations.STATUS, 0) AS TEXT) AS Download_Status
FROM Recents
INNER JOIN stations ON (Recents.Pandora_Id = stations.stationToken)
LEFT JOIN offlineStations ON (stations.stationId = offlineStations.stationId)

UNION

SELECT Recents.Pandora_Id,
	Recents.Type,
	Recents.Created_Date,
	Recents.Is_From_Collection,
	Artists.NAME,
	Artists.Icon_Url,
	Artists.Icon_Dominant_Color,
	Artists.NAME AS Artist_Name,
	0 AS isThumbprint,
	0 AS Download_Status
FROM Recents
INNER JOIN Artist_Details ON (Recents.Pandora_Id = Artist_Details.Artist_Play_Id)
INNER JOIN Artists ON (Artist_Details.Pandora_Id = Artists.Pandora_Id)