/*
    V_On_Demand_Tracks_V2
    A view on the On_Demand_Tracks table that gets Icon_Url and Icon_Dominant_Color from
    the Albums table if it exists there, otherwise from the On_Demand_Tracks table
 */

CREATE VIEW V_On_Demand_Tracks_V2
AS
SELECT On_Demand_Tracks.Pandora_Id,
       On_Demand_Tracks.Type,
       On_Demand_Tracks.Scope,
       On_Demand_Tracks.Name,
       On_Demand_Tracks.Sortable_Name,
       On_Demand_Tracks.Duration,
       On_Demand_Tracks.Track_Number,
       On_Demand_Tracks.Explicitness,
       On_Demand_Tracks.Has_Interactive,
       On_Demand_Tracks.Has_Offline,
       On_Demand_Tracks.Has_Radio_Rights,
       On_Demand_Tracks.Expiration_Time,
       On_Demand_Tracks.Album_Pandora_Id,
       On_Demand_Tracks.Artist_Pandora_Id,
       On_Demand_Tracks.Share_Url_Path,
       On_Demand_Tracks.Artist_Name,
       COALESCE(Albums.Icon_Url, On_Demand_Tracks.Icon_Url) as Icon_Url,
       COALESCE(Albums.Icon_Dominant_Color, On_Demand_Tracks.Icon_Dominant_Color) as Icon_Dominant_Color,
       On_Demand_Tracks.Last_Updated,
       On_Demand_Tracks.Last_Modified,
       On_Demand_Tracks.Is_Transient,
       On_Demand_Tracks.Has_Radio
FROM On_Demand_Tracks
LEFT JOIN Albums ON Albums.Pandora_Id = On_Demand_Tracks.Album_Pandora_Id