CREATE VIEW V_Downloaded_Artists_v2
AS
SELECT
  Artists.Pandora_Id,
  Artists.Type,
  Artists.Scope,
  Artists.Name,
  Artists.Sortable_Name,
  Artists.Icon_Url,
  Artists.Icon_Dominant_Color
FROM Artists
WHERE Artists.Pandora_Id IN (

   SELECT associatedArtistId
   FROM stations
   JOIN offlineStations ON (stations.stationToken = offlineStations.stationId AND stations.status = 3)

   UNION

    /* Collected Tracks and Album Artists */
    SELECT Artist_Pandora_Id
    FROM Albums
    WHERE Pandora_Id IN (
          SELECT Album_Pandora_Id
          FROM Downloaded_Items
          INNER JOIN On_Demand_Tracks
          ON (Downloaded_Items.Pandora_Id = On_Demand_Tracks.Pandora_Id AND Downloaded_Items.Pending_Download_Status != 6)

          UNION

          SELECT Albums.Pandora_Id
          FROM Downloaded_Items
          INNER JOIN Albums
          ON (Downloaded_Items.Pandora_Id = Albums.Pandora_Id AND Downloaded_Items.Pending_Download_Status != 6)
    )
  )