/*
    A union of two queries, first query simply finds all tracks explicitly collected, second query
    finds all tracks implicitly collected because its album was collected.
*/
CREATE VIEW V_Collected_Tracks_v2
AS
SELECT
  On_Demand_Tracks.Pandora_Id,
  On_Demand_Tracks.Type,
  On_Demand_Tracks.Scope,
  On_Demand_Tracks.Name,
  On_Demand_Tracks.Sortable_Name,
  On_Demand_Tracks.Duration,
  On_Demand_Tracks.Track_Number,
  On_Demand_Tracks.Explicitness,
  On_Demand_Tracks.Has_Radio,
  IFNULL(Albums.Local_Icon_Url, Albums.Icon_Url) AS Icon_Url,
  Albums.Icon_Dominant_Color,
  On_Demand_Tracks.Has_Interactive,
  On_Demand_Tracks.Has_Offline,
  On_Demand_Tracks.Has_Radio_Rights,
  On_Demand_Tracks.Expiration_Time,
  On_Demand_Tracks.Album_Pandora_Id,
  Albums.Name AS Album_Name,
  On_Demand_Tracks.Artist_Pandora_Id,
  On_Demand_Tracks.Share_Url_Path,
  coalesce(Artists.Name, On_Demand_Tracks.Artist_Name, "") AS Artist_Name,
  On_Demand_Tracks.Last_Modified,
  On_Demand_Tracks.Last_Updated,
  Collected_Items.Added_Time
FROM Collected_Items
/* The only difference between the two union SELECTs is here. `On_Demand_Tracks.Album_Pandora_Id` vs `On_Demand_Tracks.Pandora_Id` below */
JOIN On_Demand_Tracks ON (Collected_Items.Pandora_Id = On_Demand_Tracks.Album_Pandora_Id AND Collected_Items.Pending_Collection_Status != 6)
JOIN Albums ON (On_Demand_Tracks.Album_Pandora_Id = Albums.Pandora_Id)
LEFT JOIN Artists ON (On_Demand_Tracks.Artist_Pandora_Id = Artists.Pandora_Id)

UNION

SELECT
  On_Demand_Tracks.Pandora_Id,
  On_Demand_Tracks.Type,
  On_Demand_Tracks.Scope,
  On_Demand_Tracks.Name,
  On_Demand_Tracks.Sortable_Name,
  On_Demand_Tracks.Duration,
  On_Demand_Tracks.Track_Number,
  On_Demand_Tracks.Explicitness,
  On_Demand_Tracks.Has_Radio,
  IFNULL(Albums.Local_Icon_Url, Albums.Icon_Url) AS Icon_Url,
  Albums.Icon_Dominant_Color,
  On_Demand_Tracks.Has_Interactive,
  On_Demand_Tracks.Has_Offline,
  On_Demand_Tracks.Has_Radio_Rights,
  On_Demand_Tracks.Expiration_Time,
  On_Demand_Tracks.Album_Pandora_Id,
  Albums.Name AS Album_Name,
  On_Demand_Tracks.Artist_Pandora_Id,
  On_Demand_Tracks.Share_Url_Path,
  coalesce(Artists.Name, On_Demand_Tracks.Artist_Name, "") AS Artist_Name,
  On_Demand_Tracks.Last_Updated,
  On_Demand_Tracks.Last_Modified,
  Collected_Items.Added_Time
FROM Collected_Items
JOIN On_Demand_Tracks ON (Collected_Items.Pandora_Id = On_Demand_Tracks.Pandora_Id AND Collected_Items.Pending_Collection_Status != 6)
JOIN Albums ON (On_Demand_Tracks.Album_Pandora_Id = Albums.Pandora_Id)
LEFT JOIN Artists ON (On_Demand_Tracks.Artist_Pandora_Id = Artists.Pandora_Id)