CREATE VIEW V_Collected_Podcasts AS

/* Podcast */
SELECT * FROM (
    SELECT
      Pandora_Id,
      Type,
      -1 AS Listner_Id,
      Name,
      Sortable_Name,
      Icon_Url,
      Icon_Dominant_Color,
      Added_Time,
      Added_Time AS Last_Interacted,
      Track_Count,
      null AS Duration,
      0 AS Download_Status,
      null AS Download_Added_Time,
      null AS Explicitness,
      null AS Has_Interactive,
      null AS Has_Offline,
      null AS Has_Radio,
      null AS Expiration_Time,
      Publisher_Name,
      null as Program_Name,
      null AS Release_Date
    FROM V_Collected_Podcast_Program
    ORDER BY Added_Time DESC
)

UNION ALL

/* Podcast Episode */
SELECT
  Pandora_Id,
    Type,
    -1 AS Listner_Id,
    Name,
    Sortable_Name,
    Icon_Url,
    Icon_Dominant_Color,
    Added_Time,
    Added_Time AS Last_Interacted,
    null AS Track_Count,
    Duration,
    0 AS Download_Status,
    null AS Download_Added_Time,
    null AS Explicitness,
    Has_Interactive,
    Has_Offline,
    Has_Radio,
    Expiration_Time,
    null AS Publisher_Name,
    Program_Name,
    Release_Date
FROM V_Collected_Podcast_Episode