CREATE VIEW V_Collected_Items_v2
AS

/* Tracks */
SELECT
  Pandora_Id,
  Type,
  Scope,
  Name,
  Sortable_Name,
  null AS Release_Date,
  Duration,
  Track_Number,
  null AS Is_Compilation,
  Explicitness,
  Icon_Url,
  Icon_Dominant_Color,
  Has_Interactive,
  Has_Offline,
  Has_Radio_Rights,
  Expiration_Time,
  Album_Pandora_Id,
  Album_Name,
  Artist_Pandora_Id,
  Artist_Name,
  null AS Track_Count,
  Last_Updated,
  Added_Time,
  null AS Version,
  null AS Listner_Id,
  null AS Listner_Token,
  null AS Description,
  null AS Time_Created,
  null AS Is_Secret,
  null AS Is_Private,
  null AS Share_Url_Path,
  null AS Linked_Type,
  null AS linkedSourceId,
  null AS Playlist_Unlock_Status,
  null AS Is_Transient,
  null AS Is_Shuffle,
  0 AS Allow_Feedback
FROM V_Collected_Tracks_v2
WHERE Album_Pandora_Id NOT IN (SELECT Pandora_Id FROM V_Collected_Albums_v2)

UNION

/* Albums */
SELECT
  Pandora_Id,
  Type,
  Scope,
  Name,
  Sortable_Name,
  Release_Date,
  Duration,
  null AS Track_Number,
  Is_Compilation,
  Explicitness,
  Icon_Url,
  Icon_Dominant_Color,
  Has_Interactive,
  Has_Offline,
  Has_Radio_Rights,
  Expiration_Time,
  null AS Album_Pandora_Id,
  null AS Album_Name,
  Artist_Pandora_Id,
  Artist_Name,
  Track_Count,
  Last_Updated,
  Added_Time,
  null AS Version,
  null AS Listner_Id,
  null AS Listner_Token,
  null AS Description,
  null AS Time_Created,
  null AS Is_Secret,
  null AS Is_Private,
  null AS Share_Url_Path,
  null AS Linked_Type,
  null AS linkedSourceId,
  null AS Playlist_Unlock_Status,
  null AS Is_Transient,
  null AS Is_Shuffle,
  0 AS Allow_Feedback
FROM V_Collected_Albums_v2

UNION

/* Playlists */
SELECT
  Pandora_Id,
  Type,
  null AS Scope,
  Name,
  null AS Sortable_Name,
  null AS Release_Date,
  Duration,
  null AS Track_Number,
  null AS Is_Compilation,
  null AS Explicitness,
  Icon_Url,
  null AS Icon_Dominant_Color,
  null AS Has_Interactive,
  null AS Has_Offline,
  null AS Has_Radio_Rights,
  null AS Expiration_Time,
  null AS Album_Pandora_Id,
  null AS Album_Name,
  null AS Artist_Pandora_Id,
  null AS Artist_Name,
  Track_Count,
  Last_Updated,
  Added_Time,
  Version,
  Listner_Id,
  Listner_Token,
  Description,
  Time_Created,
  Is_Secret,
  Is_Private,
  Share_Url_Path,
  Linked_Type,
  linkedSourceId,
  Playlist_Unlock_Status,
  Is_Transient,
  null AS Is_Shuffle,
  0 AS Allow_Feedback
FROM V_Collected_Playlists_v2

UNION

/* Stations */
SELECT
  Pandora_Id,
  Type,
  null AS Scope,
  Name,
  Name AS Sortable_Name,
  null AS Release_Date,
  null AS Duration,
  null AS Track_Number,
  null AS Is_Compilation,
  null AS Explicitness,
  Icon_Url,
  Icon_Dominant_Color,
  null AS Has_Interactive,
  null AS Has_Offline,
  null AS Has_Radio_Rights,
  null AS Expiration_Time,
  null AS Album_Pandora_Id,
  null AS Album_Name,
  null AS Artist_Pandora_Id,
  null AS Artist_Name,
  null AS Track_Count,
  null AS Last_Updated,
  Added_Time,
  null AS Version,
  null AS Listner_Id,
  null AS Listner_Token,
  null AS Description,
  null AS Time_Created,
  null AS Is_Secret,
  null AS Is_Private,
  null AS Share_Url_Path,
  null AS Linked_Type,
  null AS linkedSourceId,
  null AS Playlist_Unlock_Status,
  null AS Is_Transient,
  Is_Shuffle,
  0 AS Allow_Feedback
FROM V_Collected_Stations_v2
WHERE Is_Shuffle = 0