CREATE VIEW V_Collected_Artists_v2
AS
SELECT
  Artists.Pandora_Id,
  Artists.Type,
  Artists.Scope,
  Artists.Name,
  Artists.Sortable_Name,
  Artists.Icon_Url,
  Artists.Icon_Dominant_Color
FROM Artists
WHERE Artists.Pandora_Id IN (
    /* Collected Tracks Artists */
    SELECT Artist_Pandora_Id
    FROM Collected_Items
    INNER JOIN On_Demand_Tracks ON (Collected_Items.Pandora_Id = On_Demand_Tracks.Pandora_Id AND Collected_Items.Pending_Collection_Status != 6)

    UNION

    /* Collected Album Artists */
    SELECT Artist_Pandora_Id
    FROM Collected_Items
    INNER JOIN Albums ON (Collected_Items.Pandora_Id = Albums.Pandora_Id AND Collected_Items.Pending_Collection_Status != 6)

    UNION

    /* Collected Stations Artists */
    SELECT associatedArtistId
    FROM stations
    )