/*
    v_collected_albums - Columns: COLLECTED_ALBUMS_VIEW_PROJECTION
    A union of two queries, first query simply finds all albums explicitly collected, second query
    finds all albums for which at least 2 tracks have benn collected. Note that the 'collected time'
    will be that of the most recent collected track.
*/
CREATE VIEW V_Collected_Albums_v2
AS
SELECT
  Albums.Pandora_Id,
  Albums.Type,
  Albums.Scope,
  Albums.Name,
  Albums.Sortable_Name,
  Albums.Release_Date,
  Albums.Duration,
  Albums.Is_Compilation,
  Albums.Explicitness,
  IFNULL(Albums.Local_Icon_Url, Albums.Icon_Url) AS Icon_Url,
  Albums.Icon_Dominant_Color,
  Albums.Has_Interactive,
  Albums.Has_Offline,
  Albums.Has_Radio_Rights,
  Albums.Expiration_Time,
  Albums.Artist_Pandora_Id,
  Artists.Name AS Artist_Name,
  Albums.Last_Updated,
  Albums.Last_Modified,
  Collected_Items.Added_Time,
  Albums.Track_Count
FROM Collected_Items
JOIN Albums ON (Collected_Items.Pandora_Id = Albums.Pandora_Id AND Collected_Items.Pending_Collection_Status != 6)
JOIN Artists ON (Albums.Artist_Pandora_Id = Artists.Pandora_Id)

UNION

SELECT
  Albums.Pandora_Id,
  Albums.Type,
  Albums.Scope,
  Albums.Name,
  Albums.Sortable_Name,
  Albums.Release_Date,
  Albums.Duration,
  Albums.Is_Compilation,
  Albums.Explicitness,
  IFNULL(Albums.Local_Icon_Url, Albums.Icon_Url) AS Icon_Url,
  Albums.Icon_Dominant_Color,
  Albums.Has_Interactive,
  Albums.Has_Offline,
  Albums.Has_Radio_Rights,
  Albums.Expiration_Time,
  Albums.Artist_Pandora_Id,
  Artists.Name AS Artist_Name,
  Albums.Last_Updated,
  Albums.Last_Modified,
  addedTime AS Added_Time,
  trackCount AS Track_Count
FROM (
  SELECT On_Demand_Tracks.Album_Pandora_Id,
    COUNT(*) AS trackCount,
    MAX(Collected_Items.Added_Time) AS addedTime
  FROM Collected_Items
  JOIN On_Demand_Tracks ON (Collected_Items.Pandora_Id = On_Demand_Tracks.Pandora_Id AND Collected_Items.Pending_Collection_Status != 6)
  GROUP BY On_Demand_Tracks.Album_Pandora_Id
  HAVING trackCount > 1
  )
JOIN Albums ON (Album_Pandora_Id = Albums.Pandora_Id)
JOIN Artists ON (Albums.Artist_Pandora_Id = Artists.Pandora_Id)